/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;

public class AlloyRecipesProvider
extends MIRecipesProvider {
    public AlloyRecipesProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public void buildRecipes(RecipeOutput consumer) {
        new AlloyBuilder("bronze").addIngredient("tin", 1).addIngredient("copper", 3).Build(consumer);
        new AlloyBuilder("battery_alloy").addIngredient("lead", 1).addIngredient("antimony", 1).Build(consumer);
        new AlloyBuilder("cupronickel").addIngredient("copper", 1).addIngredient("nickel", 1).Build(consumer);
        new AlloyBuilder("invar").addIngredient("iron", 2).addIngredient("nickel", 1).Build(consumer);
        new AlloyBuilder("electrum").addIngredient("gold", 1).addIngredient("silver", 1).Build(consumer);
        new AlloyBuilder("stainless_steel").addIngredient("iron", 6).addIngredient("chromium", 1).addIngredient("nickel", 1).addIngredient("manganese", 1).Build(consumer);
        new AlloyBuilder("kanthal").addIngredient("stainless_steel", 1).addIngredient("chromium", 1).addIngredient("aluminum", 1).Build(consumer);
        new AlloyBuilder("soldering_alloy").addIngredient("tin", 1).addIngredient("lead", 1).Build(consumer);
        new AlloyBuilder("le_uranium").addIngredient("uranium_238", 8).addIngredient("uranium_235", 1).Build(consumer);
        new AlloyBuilder("he_uranium").addIngredient("uranium_238", 6).addIngredient("uranium_235", 3).Build(consumer);
        new AlloyBuilder("le_mox").addIngredient("uranium_238", 8).addIngredient("plutonium", 1).Build(consumer);
        new AlloyBuilder("he_mox").addIngredient("uranium_238", 6).addIngredient("plutonium", 3).Build(consumer);
        new AlloyBuilder("superconductor").addIngredient("iridium", 1).addIngredient("annealed_copper", 3).addIngredient("yttrium", 3).addIngredient("neodymium", 2).Build(consumer);
    }

    public static class AlloyBuilder {
        public final String output;
        private int totalAmount;
        private final List<String> ingredients = new ArrayList<String>();
        private final List<Integer> ingredientAmounts = new ArrayList<Integer>();
        private static final Gson GSON = new Gson();

        public AlloyBuilder(String output) {
            this.output = output;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public AlloyBuilder addIngredient(String ingredient, int amount) {
            if (this.totalAmount + amount > 9) throw new IllegalArgumentException("Alloy with more than 9 dusts");
            if (this.ingredients.contains(ingredient)) throw new IllegalArgumentException("Trying to add the same ingredient in alloy twice : " + ingredient);
            this.totalAmount += amount;
            this.ingredients.add(ingredient);
            this.ingredientAmounts.add(amount);
            return this;
        }

        public void Build(RecipeOutput consumer) {
            MachineRecipeBuilder dusts = new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100);
            dusts.addItemOutput("modern_industrialization:" + this.output + "_dust", this.totalAmount);
            MachineRecipeBuilder tinyDusts = new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100);
            tinyDusts.addItemOutput("modern_industrialization:" + this.output + "_tiny_dust", this.totalAmount);
            for (int i = 0; i < this.ingredients.size(); ++i) {
                int n = this.ingredientAmounts.get(i);
                dusts.addItemInput("#forge:dusts/" + this.ingredients.get(i), n);
                tinyDusts.addItemInput("#forge:tiny_dusts/" + this.ingredients.get(i), n);
            }
            dusts.offerTo(consumer, "alloy/mixer/" + this.output + "/dust");
            tinyDusts.offerTo(consumer, "alloy/mixer/" + this.output + "/tiny_dust");
        }
    }
}

