/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.machines.recipe.MIRecipeJson;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.apache.commons.io.IOUtils;

public class AssemblerRecipesProvider
extends MIRecipesProvider {
    private static final Gson GSON = new Gson();
    private final PackOutput packOutput;

    public AssemblerRecipesProvider(PackOutput packOutput) {
        super(packOutput);
        this.packOutput = packOutput;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void buildRecipes(RecipeOutput consumer) {
        Path nonGeneratedResources = this.packOutput.getOutputFolder().resolve("../../main/resources");
        try (MultiPackResourceManager manager = new MultiPackResourceManager(PackType.SERVER_DATA, List.of(new PathPackResources("ngr", nonGeneratedResources, true)));){
            Map possibleTargets = manager.listResources("recipes", path -> path.getPath().endsWith(".json"));
            for (Map.Entry entry : possibleTargets.entrySet()) {
                ResourceLocation pathId = (ResourceLocation)entry.getKey();
                if (!AssemblerRecipesProvider.shouldConvertToAssembler(pathId)) continue;
                try {
                    InputStream stream = ((Resource)entry.getValue()).open();
                    try {
                        AssemblerRecipesProvider.convertToAssembler(consumer, pathId, IOUtils.toByteArray((InputStream)stream));
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to convert asbl recipe %s. Error: %s".formatted(pathId, exception), exception);
                    return;
                }
            }
        }
    }

    public static boolean shouldConvertToAssembler(ResourceLocation pathId) {
        if (pathId.getNamespace().equals("modern_industrialization")) {
            String path = pathId.toString();
            String postfix = path.substring(path.length() - 10, path.length() - 5);
            if (postfix.equals("_asbl")) {
                return true;
            }
            if (postfix.contains("_") && postfix.contains("a") && postfix.contains("s") && postfix.contains("b") && postfix.contains("l")) {
                throw new RuntimeException("Detected potential typo in _asbl.json. Crashing just to be safe. Recipe path: " + path);
            }
        }
        return false;
    }

    public static void convertToAssembler(RecipeOutput consumer, ResourceLocation recipeId, byte[] recipe) {
        String recipeString = new String(recipe, StandardCharsets.UTF_8);
        JsonElement recipeJson = JsonParser.parseString((String)recipeString);
        DataResult parsedRecipe = ShapedRecipe.Serializer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)recipeJson);
        ShapedRecipe shapedRecipe = (ShapedRecipe)Util.getOrThrow((DataResult)parsedRecipe, m -> new RuntimeException("Failed to parse shaped recipe " + recipeId + ": " + m));
        String outputSuffix = recipeId.getPath().substring("recipes/".length(), recipeId.getPath().length() - "_asbl.json".length());
        new MachineRecipeBuilder(MIRecipeJson.assemblerFromShaped(shapedRecipe)).offerTo(consumer, "assembler_generated/" + outputSuffix);
    }
}

