/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.compat.ae2.AECompatCondition;
import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.recipe.json.IMIRecipeBuilder;
import aztech.modern_industrialization.recipe.json.ShapedRecipeJson;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class CompatRecipesProvider
extends MIRecipesProvider {
    private RecipeOutput consumer;
    private String currentCompatModid;
    private ICondition[] conditions = null;

    public CompatRecipesProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public void buildRecipes(RecipeOutput consumer) {
        this.consumer = consumer;
        this.startCompat("ae2");
        this.generateAe2Compat();
    }

    private void startCompat(String modid) {
        this.currentCompatModid = modid;
        this.conditions = new ICondition[]{new ModLoadedCondition(modid)};
    }

    private void generateAe2Compat() {
        this.addMiRecipe(MIMachineRecipeTypes.ELECTROLYZER, "ae2:certus_quartz_crystal", "ae2:charged_certus_quartz_crystal", 1, 8, 60);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#forge:gems/certus_quartz", "ae2:certus_quartz_dust", 1, 2, 100);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:ender_pearl", "ae2:ender_dust", 1, 2, 100);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "ae2:fluix_crystal", "ae2:fluix_dust", 1, 2, 100);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "ae2:sky_stone_block", "ae2:sky_dust", 1, 2, 100);
        this.addCompatRecipe("mixer/fluix", (IMIRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 8, 100).addItemInput("minecraft:quartz", 1)).addItemInput("ae2:charged_certus_quartz_crystal", 1)).addItemInput("minecraft:redstone", 1)).addFluidInput((Fluid)Fluids.WATER, 1000, 0.0f)).addItemOutput("ae2:fluix_crystal", 2));
        for (Map.Entry<String, String> entry : Map.of("calculation", "ae2:certus_quartz_crystal", "engineering", "#forge:gems/diamond", "logic", "#forge:ingots/gold").entrySet()) {
            String type = entry.getKey();
            String ingredient = entry.getValue();
            this.addCompatRecipe("printed_" + type + "_processor", (IMIRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.PACKER, 8, 200).addItemInput(ingredient, 1)).addItemInput("ae2:" + type + "_processor_press", 1, 0.0f)).addItemOutput("ae2:printed_" + type + "_processor", 1));
            this.addCompatRecipe(type + "_processor", (IMIRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.ASSEMBLER, 8, 200).addItemInput("ae2:printed_" + type + "_processor", 1)).addItemInput("ae2:printed_silicon", 1)).addFluidInput(MIFluids.MOLTEN_REDSTONE, 90)).addItemOutput("ae2:" + type + "_processor", 1));
        }
        this.addCompatRecipe("printed_silicon", (IMIRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.PACKER, 8, 200).addItemInput("#forge:silicon", 1)).addItemInput("ae2:silicon_press", 1, 0.0f)).addItemOutput("ae2:printed_silicon", 1));
        this.addCompatRecipe("printed_silicon_from_ingot", (IMIRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.PACKER, 8, 200).addItemInput(MIMaterials.SILICON.getPart(MIParts.INGOT), 1)).addItemInput("ae2:silicon_press", 1, 0.0f)).addItemOutput("ae2:printed_silicon", 1));
        this.conditions = new ICondition[]{AECompatCondition.INSTANCE};
        for (DyeColor color : DyeColor.values()) {
            ShapedRecipeJson meWiresDirect = new ShapedRecipeJson("modern_industrialization:" + color.getName() + "_me_wire", 16, "qCq", "GdG", "qCq").addInput('C', "modern_industrialization:bronze_curved_plate").addInput('G', "#ae2:glass_cable").addInput('d', "#forge:dyes/" + color.getName()).addInput('q', "ae2:quartz_fiber");
            this.addCompatRecipe("dyes/" + color.getName() + "/craft/me_wire_direct", meWiresDirect);
            this.addCompatRecipe("dyes/" + color.getName() + "/assembler/me_wire_direct", meWiresDirect.exportToAssembler());
            ShapedRecipeJson eightMeWires = new ShapedRecipeJson("modern_industrialization:" + color.getName() + "_me_wire", 8, "ppp", "pdp", "ppp").addInput('d', "#forge:dyes/" + color.getName()).addInput('p', "#modern_industrialization:me_wires");
            this.addCompatRecipe("dyes/" + color.getName() + "/craft/me_wire_8", eightMeWires);
            this.addCompatRecipe("dyes/" + color.getName() + "/mixer/me_wire_8", eightMeWires.exportToMachine(MIMachineRecipeTypes.MIXER, 2, 100, 1));
            this.addCompatRecipe("dyes/" + color.getName() + "/craft/me_wire_1", new ShapedRecipeJson("modern_industrialization:" + color.getName() + "_me_wire", 1, "pd").addInput('d', "#forge:dyes/" + color.getName()).addInput('p', "#modern_industrialization:me_wires"));
        }
        this.addCompatRecipe("dyes/decolor/craft/me_wire_8", new ShapedRecipeJson("modern_industrialization:me_wire", 8, "ppp", "pbp", "ppp").addInput('b', "minecraft:water_bucket").addInput('p', "#modern_industrialization:me_wires"));
        this.addCompatRecipe("dyes/decolor/craft/me_wire_1", new ShapedRecipeJson("modern_industrialization:me_wire", 1, "pb").addInput('b', "minecraft:water_bucket").addInput('p', "#modern_industrialization:me_wires"));
        this.addCompatRecipe("dyes/decolor/mixer/me_wire", (IMIRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput("#modern_industrialization:me_wires", 1)).addFluidInput((Fluid)Fluids.WATER, 125)).addItemOutput("modern_industrialization:me_wire", 1));
        ShapedRecipeJson meWiresDirect = new ShapedRecipeJson("modern_industrialization:me_wire", 16, "qCq", "G G", "qCq").addInput('C', "modern_industrialization:bronze_curved_plate").addInput('G', "#ae2:glass_cable").addInput('q', "ae2:quartz_fiber");
        this.addCompatRecipe("craft/me_wire_direct", meWiresDirect);
        this.addCompatRecipe("assembler/me_wire_direct", meWiresDirect.exportToAssembler());
    }

    private void addMiRecipe(MachineRecipeType machine, String input, String output, int outputAmount) {
        this.addMiRecipe(machine, input, output, outputAmount, 2, 200);
    }

    private void addMiRecipe(MachineRecipeType machine, String input, String output, int outputAmount, int eu, int duration) {
        String id = "%s/%s_to_%s".formatted(machine.getPath(), input.replace('#', '_').replace(':', '_').replace('/', '_'), output.replace(':', '_'));
        this.addCompatRecipe(id, (IMIRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(machine, eu, duration).addItemInput(input, 1)).addItemOutput(output, outputAmount));
    }

    private void addCompatRecipe(String id, IMIRecipeBuilder recipeJson) {
        id = "compat/%s/%s".formatted(this.currentCompatModid, id);
        recipeJson.offerTo(this.consumer.withConditions(this.conditions), id);
    }
}

