/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class TagsToGenerate {
    static final Map<String, List<ItemLike>> tagToItemMap = new HashMap<String, List<ItemLike>>();
    static final Set<String> optionalTags = new HashSet<String>();
    public static final Map<String, String> tagTranslations = new HashMap<String, String>();
    static final Map<String, Set<String>> tagToBeAddedToAnotherTag = new HashMap<String, Set<String>>();

    private static void addTranslation(String tag, String tagEnglishName) {
        ResourceLocation tagId = new ResourceLocation(tag);
        tagTranslations.put("tag.%s.%s".formatted(tagId.getNamespace(), tagId.getPath()).replace('/', '.'), tagEnglishName);
    }

    public static void generateTag(String tag, ItemLike item, String tagEnglishName) {
        if (tag.startsWith("#")) {
            throw new IllegalArgumentException("Tag must not start with #: " + tag);
        }
        tagToItemMap.computeIfAbsent(tag, t -> new ArrayList()).add(item);
        TagsToGenerate.addTranslation(tag, tagEnglishName);
    }

    public static void addTagToTag(String tagTobeAdded, String tagTarget, String targetEnglishName) {
        if (tagTobeAdded.startsWith("#")) {
            throw new IllegalArgumentException("Tag must not start with #: " + tagTobeAdded);
        }
        if (tagTarget.startsWith("#")) {
            throw new IllegalArgumentException("Tag must not start with #: " + tagTarget);
        }
        tagToBeAddedToAnotherTag.computeIfAbsent(tagTarget, t -> new TreeSet()).add(tagTobeAdded);
        TagsToGenerate.addTranslation(tagTarget, targetEnglishName);
    }

    public static void generateTag(TagKey<Item> tag, ItemLike item, String tagEnglishName) {
        TagsToGenerate.generateTag(tag.location().toString(), item, tagEnglishName);
    }

    public static void markTagOptional(TagKey<Item> tag) {
        optionalTags.add(tag.location().toString());
    }
}

