/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.translation;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.datagen.translation.EnglishTranslation;
import aztech.modern_industrialization.definition.Definition;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;

public final class TranslationProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String OUTPUT_PATH = "assets/modern_industrialization/lang/en_us.json";
    private final PackOutput packOutput;
    private final boolean runtimeDatagen;
    private final Map<String, String> translationPairs = new TreeMap<String, String>();

    public TranslationProvider(PackOutput packOutput, boolean runtimeDatagen) {
        this.packOutput = packOutput;
        this.runtimeDatagen = runtimeDatagen;
    }

    public void addTranslation(String key, String englishValue) {
        if (this.translationPairs.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Error adding translation key %s for translation %s : already registered for translation %s", key, englishValue, this.translationPairs.get(key)));
        }
        this.translationPairs.put(key, englishValue);
    }

    private void addManualEntries() {
        this.addTranslation("block.modern_industrialization.pipe", "Pipe(s)");
        this.addTranslation("book.modern_industrialization.landing_text", "Welcome to Modern Industrialization! To get started, be sure to collect a lot of Copper Ore and Tin Ore.");
        this.addTranslation("book.modern_industrialization.subtitle", "Modern Industrialization");
        this.addTranslation("entity.minecraft.villager.modern_industrialization.industrialist", "Industrialist");
        this.addTranslation("key.modern_industrialization.activate", "Toggle Flight");
        this.addTranslation("text.autoconfig.modern_industrialization.title", "Modern Industrialization Menu");
        this.addTranslation("tag.modern_industrialization.replicator_blacklist", "Replicator Blacklist");
        this.addTranslation("config.jade.plugin_modern_industrialization.overclock", "Machine Overclock");
        this.addTranslation("config.jade.plugin_modern_industrialization.pipe", "Pipe Information");
    }

    private void collectTranslationEntries() {
        this.addManualEntries();
        for (MIText mIText : MIText.values()) {
            this.addTranslation(mIText.getTranslationKey(), mIText.getEnglishText());
            for (String additionalKey : mIText.getAdditionalTranslationKey()) {
                this.addTranslation(additionalKey, mIText.getEnglishText());
            }
        }
        for (MIText mIText : MIConfig.class.getFields()) {
            EnglishTranslation englishTranslation = ((Field)((Object)mIText)).getAnnotation(EnglishTranslation.class);
            if (englishTranslation == null) continue;
            this.addTranslation("text.autoconfig.modern_industrialization.option." + ((Field)((Object)mIText)).getName(), englishTranslation.value());
        }
        for (Definition definition : Definition.TRANSLATABLE_DEFINITION) {
            this.addTranslation(definition.getTranslationKey(), definition.getEnglishName());
        }
        for (Map.Entry entry : MITooltips.TOOLTIPS_ENGLISH_TRANSLATION.entrySet()) {
            this.addTranslation((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : ReiMachineRecipes.categories.entrySet()) {
            this.addTranslation("rei_categories.modern_industrialization." + (String)entry.getKey(), ((MachineCategoryParams)entry.getValue()).englishName);
        }
        for (Map.Entry entry : TagsToGenerate.tagTranslations.entrySet()) {
            this.addTranslation((String)entry.getKey(), (String)entry.getValue());
        }
        for (ElectricBlastFurnaceBlockEntity.Tier tier : ElectricBlastFurnaceBlockEntity.tiers) {
            this.addTranslation(tier.getTranslationKey(), tier.englishName());
        }
        for (CableTier cableTier : CableTier.allTiers()) {
            this.addTranslation(cableTier.shortEnglishKey(), cableTier.shortEnglishName);
            this.addTranslation(cableTier.longEnglishKey(), cableTier.longEnglishName);
        }
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.innerRun(output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, Util.backgroundExecutor());
    }

    public void innerRun(CachedOutput cache) throws IOException {
        this.collectTranslationEntries();
        this.customJsonSave(cache, GSON.toJsonTree(this.translationPairs), this.packOutput.getOutputFolder().resolve(OUTPUT_PATH));
        if (this.runtimeDatagen) {
            return;
        }
        Path manualTranslationsPath = this.packOutput.getOutputFolder().resolve("../../main/resources/assets/modern_industrialization/lang");
        try (Stream<Path> paths = Files.walk(manualTranslationsPath, 1, new FileVisitOption[0]);){
            paths.forEach(path -> {
                try {
                    String lang = path.getFileName().toString();
                    if (lang.endsWith(".json")) {
                        lang = lang.substring(0, lang.length() - 5);
                        TreeMap manualTranslations = (TreeMap)GSON.fromJson(Files.readString(path), TreeMap.class);
                        TreeMap<String, Object> output = new TreeMap<String, Object>();
                        for (Map.Entry<String, String> entry : this.translationPairs.entrySet()) {
                            if (manualTranslations.containsKey(entry.getKey())) continue;
                            output.put(entry.getKey(), "[UNTRANSLATED] " + entry.getValue());
                        }
                        for (Map.Entry<String, String> entry : manualTranslations.entrySet()) {
                            if (this.translationPairs.containsKey(entry.getKey())) {
                                output.put(entry.getKey(), entry.getValue());
                                continue;
                            }
                            output.put(entry.getKey(), "[UNUSED, PLEASE REMOVE] " + entry.getValue());
                        }
                        Path savePath = this.packOutput.getOutputFolder().resolve("assets/modern_industrialization/lang/untranslated/" + lang + ".json");
                        this.customJsonSave(cache, GSON.toJsonTree(output), savePath);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private void customJsonSave(CachedOutput cache, JsonElement jsonElement, Path path) throws IOException {
        String sortedJson = GSON.toJson(jsonElement);
        String prettyPrinted = sortedJson.replace("\\u0027", "'");
        cache.writeIfNeeded(path, prettyPrinted.getBytes(StandardCharsets.UTF_8), Hashing.sha1().hashString((CharSequence)prettyPrinted, StandardCharsets.UTF_8));
    }

    public String getName() {
        return "Translations";
    }
}

