/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.definition;

import aztech.modern_industrialization.MIIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public abstract class Definition {
    public static List<Definition> TRANSLATABLE_DEFINITION = new ArrayList<Definition>();
    private final ResourceLocation id;
    private final String englishName;

    public String getEnglishName() {
        return this.englishName;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public abstract String getTranslationKey();

    public Definition(String englishName, String path, boolean addToTranslation) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(englishName, "englishName");
        this.id = new MIIdentifier(path);
        this.englishName = englishName;
        if (addToTranslation) {
            TRANSLATABLE_DEFINITION.add(this);
        }
    }

    public Definition(String englishName, String path) {
        this(englishName, path, true);
    }

    public String getResourceAsString(boolean id) {
        if (id) {
            return this.id.toString();
        }
        return this.id.getPath();
    }

    public String path() {
        return this.getResourceAsString(false);
    }

    public String id() {
        return this.getResourceAsString(true);
    }
}

