/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.network.machines.UpdateFluidSlotPacket;
import aztech.modern_industrialization.network.machines.UpdateItemSlotPacket;
import aztech.modern_industrialization.util.Simulation;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public abstract class ConfigurableScreenHandler
extends AbstractContainerMenu {
    private static final int PLAYER_SLOTS = 36;
    public boolean lockingMode = false;
    protected Inventory playerInventory;
    public final MIInventory inventory;
    private List<ConfigurableItemStack> trackedItems;
    private List<ConfigurableFluidStack> trackedFluids;
    private final Map<Slot, SlotGroup> slotGroups = new IdentityHashMap<Slot, SlotGroup>();
    private final Set<SlotGroup> slotGroupIndices = new LinkedHashSet<SlotGroup>();

    protected ConfigurableScreenHandler(MenuType<?> type, int syncId, Inventory playerInventory, MIInventory inventory) {
        super(type, syncId);
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        if (playerInventory.player instanceof ServerPlayer) {
            this.trackedItems = ConfigurableItemStack.copyList(inventory.getItemStacks());
            this.trackedFluids = ConfigurableFluidStack.copyList(inventory.getFluidStacks());
        }
    }

    public void updateSlot(int index, Slot slot) {
        Slot existingSlot = this.getSlot(index);
        SlotGroup slotGroup = this.slotGroups.remove(existingSlot);
        if (slotGroup != null) {
            this.slotGroups.put(slot, slotGroup);
        }
        this.slots.set(index, (Object)slot);
    }

    protected Slot addSlot(Slot slot, SlotGroup slotGroup) {
        this.slotGroups.put(slot, slotGroup);
        this.slotGroupIndices.add(slotGroup);
        return super.addSlot(slot);
    }

    public void broadcastChanges() {
        Player player = this.playerInventory.player;
        if (player instanceof ServerPlayer) {
            int i;
            ServerPlayer player2 = (ServerPlayer)player;
            for (i = 0; i < this.trackedItems.size(); ++i) {
                if (this.trackedItems.get(i).equals(this.inventory.getItemStacks().get(i))) continue;
                this.trackedItems.set(i, new ConfigurableItemStack(this.inventory.getItemStacks().get(i)));
                new UpdateItemSlotPacket(this.containerId, i, this.trackedItems.get(i)).sendToClient(player2);
            }
            for (i = 0; i < this.trackedFluids.size(); ++i) {
                if (this.trackedFluids.get(i).equals(this.inventory.getFluidStacks().get(i))) continue;
                this.trackedFluids.set(i, new ConfigurableFluidStack(this.inventory.getFluidStacks().get(i)));
                new UpdateFluidSlotPacket(this.containerId, i, this.trackedFluids.get(i)).sendToClient(player2);
            }
        }
        super.broadcastChanges();
    }

    public void clicked(int i, int j, ClickType actionType, Player player) {
        if (i >= 0) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
                ConfigurableFluidStack.ConfigurableFluidSlot fluidSlot = (ConfigurableFluidStack.ConfigurableFluidSlot)slot;
                if (actionType != ClickType.PICKUP) {
                    return;
                }
                ConfigurableFluidStack fluidStack = fluidSlot.getConfStack();
                if (this.lockingMode) {
                    fluidStack.togglePlayerLock();
                } else {
                    fluidSlot.playerInteract(this.createCarriedSlotAccess(), player, true);
                }
                return;
            }
            if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
                ConfigurableItemStack.ConfigurableItemSlot itemSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot;
                if (this.lockingMode) {
                    switch (actionType) {
                        case PICKUP: {
                            ConfigurableItemStack itemStack = itemSlot.getConfStack();
                            itemStack.togglePlayerLock(this.getCarried().getItem());
                            break;
                        }
                        case QUICK_MOVE: {
                            this.insertItem(itemSlot, 0, 36, true);
                            if (!slot.getItem().isEmpty()) break;
                            itemSlot.getConfStack().playerLock(Items.AIR, Simulation.ACT);
                        }
                    }
                    return;
                }
            }
        }
        super.clicked(i, j, actionType, player);
    }

    public final ItemStack quickMoveStack(Player player, int slotIndex) {
        this.handleShiftClick(player, slotIndex);
        return ItemStack.EMPTY;
    }

    protected void handleShiftClick(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem() && slot.mayPickup(player)) {
            if (slotIndex < 36) {
                SlotAccess ctx = SlotAccess.forContainer((Container)player.getInventory(), (int)slot.getContainerSlot());
                for (Slot maybeFluidSlot : this.slots) {
                    ConfigurableFluidStack.ConfigurableFluidSlot fluidSlot;
                    if (!(maybeFluidSlot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) || !(fluidSlot = (ConfigurableFluidStack.ConfigurableFluidSlot)maybeFluidSlot).playerInteract(ctx, player, false)) continue;
                    return;
                }
                for (SlotGroup group : this.slotGroupIndices) {
                    if (!this.insertItem(slot, 36, this.slots.size(), false, s -> this.slotGroups.get(s) == group)) continue;
                    return;
                }
                if (slotIndex < 27) {
                    this.insertItem(slot, 27, 36, false);
                } else {
                    this.insertItem(slot, 0, 27, false);
                }
            } else {
                this.insertItem(slot, 0, 36, true);
            }
        }
    }

    @Deprecated
    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        throw new UnsupportedOperationException("Don't use this shit, use the one below instead.");
    }

    protected boolean insertItem(Slot sourceSlot, int startIndex, int endIndex, boolean fromLast) {
        return this.insertItem(sourceSlot, startIndex, endIndex, fromLast, s -> true);
    }

    protected boolean insertItem(Slot sourceSlot, int startIndex, int endIndex, boolean fromLast, Predicate<Slot> filter) {
        boolean insertedSomething = false;
        for (int iter = 0; iter < 2; ++iter) {
            int i;
            boolean allowEmptySlots = iter == 1;
            int n = i = fromLast ? endIndex - 1 : startIndex;
            while (0 <= i && i < endIndex && !sourceSlot.getItem().isEmpty()) {
                int maxInsert;
                Slot targetSlot = this.getSlot(i);
                ItemStack sourceStack = sourceSlot.getItem();
                ItemStack targetStack = targetSlot.getItem();
                if (filter.test(targetSlot) && targetSlot.mayPlace(sourceStack) && (allowEmptySlots && targetStack.isEmpty() || ItemStack.isSameItemSameTags((ItemStack)targetStack, (ItemStack)sourceStack)) && (maxInsert = targetSlot.getMaxStackSize(sourceStack) - targetStack.getCount()) > 0) {
                    ItemStack newTargetStack = sourceStack.split(maxInsert);
                    newTargetStack.grow(targetStack.getCount());
                    targetSlot.set(newTargetStack);
                    sourceSlot.setChanged();
                    insertedSomething = true;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return insertedSomething;
    }

    public boolean hasUnlockedSlot() {
        for (Slot slot : this.slots) {
            if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
                ConfigurableItemStack.ConfigurableItemSlot cis = (ConfigurableItemStack.ConfigurableItemSlot)slot;
                if (!cis.getConfStack().playerLocked && cis.getConfStack().playerLockable) {
                    return true;
                }
            }
            if (!(slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot)) continue;
            ConfigurableFluidStack.ConfigurableFluidSlot cfs = (ConfigurableFluidStack.ConfigurableFluidSlot)slot;
            if (cfs.getConfStack().playerLocked || !cfs.getConfStack().playerLockable) continue;
            return true;
        }
        return false;
    }

    public void lockAll(boolean lock) {
        for (Slot slot : this.slots) {
            if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
                ConfigurableItemStack.ConfigurableItemSlot cis = (ConfigurableItemStack.ConfigurableItemSlot)slot;
                if (cis.getConfStack().playerLocked != lock) {
                    cis.getConfStack().togglePlayerLock();
                }
            }
            if (!(slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot)) continue;
            ConfigurableFluidStack.ConfigurableFluidSlot cfs = (ConfigurableFluidStack.ConfigurableFluidSlot)slot;
            if (cfs.getConfStack().playerLocked == lock) continue;
            cfs.getConfStack().togglePlayerLock();
        }
    }
}

