/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIStorage;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StorageUtil;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.ResourceAmount;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import com.google.common.primitives.Ints;
import java.util.List;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class MIFluidStorage
extends MIStorage<Fluid, FluidVariant, ConfigurableFluidStack> {
    public final IFluidHandler fluidHandler = new FluidHandler();

    public MIFluidStorage(List<ConfigurableFluidStack> stacks) {
        super(stacks, true);
    }

    public class FluidHandler
    implements IFluidHandler {
        public int getTanks() {
            return MIFluidStorage.this.stacks.size();
        }

        public FluidStack getFluidInTank(int tank) {
            ConfigurableFluidStack stack = (ConfigurableFluidStack)MIFluidStorage.this.stacks.get(tank);
            return stack.getVariant().toStack(Ints.saturatedCast((long)stack.getAmount()));
        }

        public int getTankCapacity(int tank) {
            return Ints.saturatedCast((long)((ConfigurableFluidStack)MIFluidStorage.this.stacks.get(tank)).getCapacity());
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return ((ConfigurableFluidStack)MIFluidStorage.this.stacks.get(tank)).isResourceAllowedByLock(stack.getFluid());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return 0;
            }
            try (Transaction tx = Transaction.hackyOpen();){
                long result = MIFluidStorage.this.insert(FluidVariant.of(resource), (long)resource.getAmount(), (TransactionContext)tx);
                if (result > 0L && action.execute()) {
                    tx.commit();
                }
                int n = (int)result;
                return n;
            }
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            try (Transaction tx = Transaction.hackyOpen();){
                long result = MIFluidStorage.this.extract(FluidVariant.of(resource), (long)resource.getAmount(), (TransactionContext)tx);
                if (result > 0L && action.execute()) {
                    tx.commit();
                }
                FluidStack ret = resource.copy();
                ret.setAmount((int)result);
                FluidStack fluidStack = ret;
                return fluidStack;
            }
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (maxDrain <= 0) {
                return FluidStack.EMPTY;
            }
            try (Transaction tx = Transaction.hackyOpen();){
                ResourceAmount<FluidVariant> result = StorageUtil.extractAny(MIFluidStorage.this, maxDrain, tx);
                if (result == null) {
                    FluidStack fluidStack = FluidStack.EMPTY;
                    return fluidStack;
                }
                if (action.execute()) {
                    tx.commit();
                }
                FluidStack fluidStack = result.resource().toStack((int)result.amount());
                return fluidStack;
            }
        }
    }
}

