/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.pipes.impl.CamouflageHelper;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ConfigCardItem
extends Item {
    public static final String TAG_SAVEDCONFIG = "savedconfig";
    public static final String TAG_CAMOUFLAGE = "camouflage";

    public ConfigCardItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext c) {
        Player player = c.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            PipeBlock pipe;
            InteractionResult pipeUseResult;
            BlockState hitState = c.getLevel().getBlockState(c.getClickedPos());
            InteractionHand usedHand = c.getHand();
            Block block = hitState.getBlock();
            if (block instanceof PipeBlock && (pipeUseResult = (pipe = (PipeBlock)block).use(c.getLevel().getBlockState(c.getClickedPos()), c.getLevel(), c.getClickedPos(), c.getPlayer(), c.getHand(), new BlockHitResult(c.getClickLocation(), c.getClickedFace(), c.getClickedPos(), c.isInside()))).consumesAction()) {
                return pipeUseResult;
            }
            if (ConfigCardItem.setCamouflage(player, usedHand, hitState)) {
                return InteractionResult.sidedSuccess((boolean)c.getLevel().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public static boolean setCamouflage(Player player, InteractionHand usedHand, BlockState hitState) {
        if (CamouflageHelper.isReasonableCamouflage(hitState)) {
            player.getItemInHand(usedHand).removeTagKey(TAG_SAVEDCONFIG);
            player.getItemInHand(usedHand).getOrCreateTag().put(TAG_CAMOUFLAGE, (Tag)NbtUtils.writeBlockState((BlockState)hitState));
            player.displayClientMessage((Component)MITooltips.line(MIText.ConfigCardSetCamouflage, Style.EMPTY).arg(hitState, MITooltips.BLOCK_STATE_PARSER).build(), true);
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player.isShiftKeyDown()) {
            player.getItemInHand(usedHand).removeTagKey(TAG_SAVEDCONFIG);
            player.getItemInHand(usedHand).removeTagKey(TAG_CAMOUFLAGE);
            player.displayClientMessage((Component)MIText.ConfigCardCleared.text(), true);
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(usedHand), (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        BlockState camouflage;
        CompoundTag savedConfigTag = stack.getTagElement(TAG_SAVEDCONFIG);
        if (savedConfigTag != null) {
            int filterSize = ConfigCardItem.readItemPipeFilter(savedConfigTag).size();
            MutableComponent component = filterSize == 0 ? MIText.ConfigCardConfiguredNoItems.text() : MIText.ConfigCardConfiguredItems.text(Component.literal((String)("" + filterSize)).setStyle(MITooltips.NUMBER_TEXT));
            tooltipComponents.add((Component)component.withStyle(MITooltips.DEFAULT_STYLE));
        }
        if (!(camouflage = ConfigCardItem.readCamouflage(stack)).isAir()) {
            tooltipComponents.add((Component)MITooltips.line(MIText.ConfigCardConfiguredCamouflage, Style.EMPTY).arg(camouflage, MITooltips.BLOCK_STATE_PARSER).build());
        }
    }

    private static List<ItemStack> readItemPipeFilter(CompoundTag tag) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ListTag filterTag = tag.getList("filter", 10);
        for (int i = 0; i < filterTag.size(); ++i) {
            ItemStack filterStack = ItemStack.of((CompoundTag)filterTag.getCompound(i));
            if (filterStack.isEmpty()) continue;
            filterStack.setCount(1);
            stacks.add(filterStack);
        }
        return stacks;
    }

    public static BlockState readCamouflage(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        if (tag != null) {
            CompoundTag coverTag = tag.getCompound(TAG_CAMOUFLAGE);
            return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)coverTag);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        CompoundTag savedConfigTag = stack.getTagElement(TAG_SAVEDCONFIG);
        if (savedConfigTag != null) {
            List<ItemStack> stacks = ConfigCardItem.readItemPipeFilter(savedConfigTag);
            return stacks.isEmpty() ? Optional.empty() : Optional.of(new TooltipData(stacks));
        }
        BlockState camouflage = ConfigCardItem.readCamouflage(stack);
        if (!camouflage.isAir()) {
            return Optional.of(new TooltipData(List.of(new ItemStack((ItemLike)camouflage.getBlock()))));
        }
        return Optional.empty();
    }

    public record TooltipData(List<ItemStack> filter) implements TooltipComponent
    {
    }
}

