/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ForgeTool
extends TieredItem {
    public static final TagKey<Item> TAG = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)new MIIdentifier("forge_hammer_tools"));
    public static Tier STEEL = new Tier(){

        public int getUses() {
            return 650;
        }

        public float getSpeed() {
            return 7.0f;
        }

        public float getAttackDamageBonus() {
            return 2.5f;
        }

        public int getLevel() {
            return 2;
        }

        public int getEnchantmentValue() {
            return 16;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of(TAG);
        }

        public String toString() {
            return "modern_industrialization:steel";
        }
    };

    public ForgeTool(Tier material, Item.Properties p) {
        super(ForgeTool.forgeHammerMaterial(material), p.stacksTo(1));
        TagsToGenerate.generateTag(TAG, (ItemLike)this, "Forge Hammer Tools");
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return false;
    }

    private static Tier forgeHammerMaterial(final Tier normalTier) {
        return new Tier(){

            public int getUses() {
                return normalTier.getUses() * 20 / 3;
            }

            public float getSpeed() {
                return normalTier.getSpeed();
            }

            public float getAttackDamageBonus() {
                return normalTier.getAttackDamageBonus();
            }

            public int getLevel() {
                return normalTier.getLevel();
            }

            public int getEnchantmentValue() {
                return normalTier.getEnchantmentValue();
            }

            public Ingredient getRepairIngredient() {
                return normalTier.getRepairIngredient();
            }

            public String toString() {
                return normalTier.toString().toLowerCase(Locale.ROOT) + "_forge_tool";
            }
        };
    }
}

