/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public interface ItemContainingItemHelper
extends ContainerItem<ItemVariant> {
    default public boolean handleStackedOnOther(ItemStack stackBarrel, Slot slot, ClickAction clickType, Player player) {
        if (clickType == ClickAction.SECONDARY && slot.allowModification(player)) {
            MutableObject ref = new MutableObject((Object)slot.getItem());
            boolean result = this.handleClick(player, stackBarrel, (Mutable<ItemStack>)ref);
            slot.set((ItemStack)ref.getValue());
            return result;
        }
        return false;
    }

    default public boolean handleOtherStackedOnMe(ItemStack stackBarrel, ItemStack itemStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (clickType == ClickAction.SECONDARY && slot.allowModification(player)) {
            MutableObject ref = new MutableObject((Object)itemStack);
            boolean result = this.handleClick(player, stackBarrel, (Mutable<ItemStack>)ref);
            cursorStackReference.set((ItemStack)ref.getValue());
            slot.setChanged();
            return result;
        }
        return false;
    }

    default public boolean handleClick(Player player, ItemStack barrelLike, Mutable<ItemStack> otherStack) {
        if (!(barrelLike.getItem() instanceof ItemContainingItemHelper)) {
            throw new AssertionError((Object)"This method should only be called on a ItemContainingItemHelper.");
        }
        ContainerItem.ItemHandler barrelHandler = new ContainerItem.ItemHandler(barrelLike, this);
        int otherCount = ((ItemStack)otherStack.getValue()).getCount();
        ItemStack leftover = barrelHandler.insertItem(0, (ItemStack)otherStack.getValue(), false);
        int insertedCount = otherCount - leftover.getCount();
        otherStack.setValue((Object)leftover);
        if (insertedCount != 0) {
            return true;
        }
        ItemStack heldStack = barrelHandler.getStackInSlot(0);
        if (!heldStack.isEmpty() && (((ItemStack)otherStack.getValue()).isEmpty() || ItemStack.isSameItemSameTags((ItemStack)heldStack, (ItemStack)((ItemStack)otherStack.getValue())))) {
            ItemStack extracted = barrelHandler.extractItem(0, heldStack.getMaxStackSize() - ((ItemStack)otherStack.getValue()).getCount(), false);
            extracted.grow(((ItemStack)otherStack.getValue()).getCount());
            otherStack.setValue((Object)extracted);
            return true;
        }
        return !this.isEmpty(barrelLike) || !((ItemStack)otherStack.getValue()).isEmpty();
    }

    @Override
    default public ItemVariant getResource(ItemStack stack) {
        CompoundTag tag = stack.getTagElement("BlockEntityTag");
        if (tag != null) {
            return ItemVariant.fromNbt(tag.getCompound("item"));
        }
        return ItemVariant.blank();
    }

    @Override
    default public void setResourceNoClean(ItemStack stack, ItemVariant item) {
        stack.getOrCreateTagElement("BlockEntityTag").put("item", (Tag)item.toNbt());
        this.onChange(stack);
    }
}

