/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.SteamDrillItem;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public final class SteamDrillHooks {
    @Nullable
    public static Direction breakingSide = null;

    private SteamDrillHooks() {
    }

    public static void overrideDestroyProgress(Player pPlayer, BlockGetter pLevel, CallbackInfoReturnable<Float> cir) {
        if (!MIItem.STEAM_MINING_DRILL.is(pPlayer.getMainHandItem())) {
            return;
        }
        SteamDrillItem.Area area = SteamDrillItem.getArea(pLevel, pPlayer);
        if (area == null) {
            return;
        }
        MutableFloat minProgress = new MutableFloat(Float.MAX_VALUE);
        MutableBoolean foundAny = new MutableBoolean(false);
        SteamDrillItem.forEachMineableBlock(pLevel, area, (LivingEntity)pPlayer, (blockPos, state) -> {
            float destroyProgress = state.getBlock().getDestroyProgress(state, pPlayer, pLevel, blockPos);
            if ((double)destroyProgress > 1.0E-9) {
                foundAny.setTrue();
                minProgress.setValue(Math.min(minProgress.getValue().floatValue(), destroyProgress));
            }
        });
        if (foundAny.isTrue()) {
            cir.setReturnValue((Object)minProgress.getValue());
            cir.cancel();
        }
    }

    private static void onStartBreaking(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getUseItem() == Event.Result.DENY || event.getSide().isServer()) {
            return;
        }
        breakingSide = event.getFace();
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, SteamDrillHooks::onStartBreaking);
    }
}

