/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.items.DynamicToolItem;
import aztech.modern_industrialization.items.ItemContainingItemHelper;
import aztech.modern_industrialization.items.ItemHelper;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.GeometryHelper;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.TextHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.TierSortingRegistry;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.Mutable;
import org.jetbrains.annotations.Nullable;

public class SteamDrillItem
extends Item
implements DynamicToolItem,
ItemContainingItemHelper {
    public static final StorageBehaviour<ItemVariant> DRILL_BEHAVIOUR = new StorageBehaviour<ItemVariant>(){

        @Override
        public long getCapacityForResource(ItemVariant resource) {
            return resource.getItem().getMaxStackSize();
        }

        @Override
        public boolean canInsert(ItemVariant item) {
            int burnTicks = CommonHooks.getBurnTime((ItemStack)item.toStack(), null);
            return burnTicks > 0;
        }
    };
    private static final int FULL_WATER = 18000;

    public SteamDrillItem(Item.Properties settings) {
        super(settings.stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    private static boolean isNotSilkTouch(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        return tag != null && tag.getBoolean("nosilk");
    }

    private static void setSilkTouch(ItemStack stack, boolean silkTouch) {
        if (silkTouch) {
            stack.removeTagKey("nosilk");
        } else {
            stack.getOrCreateTag().putBoolean("nosilk", true);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !newStack.is((Item)this) || slotChanged;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is((Item)this) || !this.canUse(newStack) || CommonProxy.INSTANCE.shouldSteamDrillForceBreakReset();
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (this.isSupportedBlock(stack, state) && this.canUse(stack) && TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.NETHERITE, (BlockState)state)) {
            return true;
        }
        return super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.canUse(stack)) {
            if (this.isCorrectToolForDrops(stack, state)) {
                float speed = 4.0f;
                Player player = CommonProxy.INSTANCE.findUser(stack);
                if (player != null && player.isShiftKeyDown()) {
                    speed *= 4.0f;
                }
                return speed;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND && this.canUse(stack)) {
            return ItemHelper.createToolModifiers(5.0);
        }
        return ImmutableMultimap.of();
    }

    @Nullable
    public static Area getArea(BlockGetter level, Player player) {
        if (player.isShiftKeyDown()) {
            return null;
        }
        HitResult rayTraceResult = SteamDrillItem.rayTraceSimple(level, player, 0.0f);
        if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockResult = (BlockHitResult)rayTraceResult;
            Direction facing = blockResult.getDirection();
            return SteamDrillItem.getArea(blockResult.getBlockPos(), facing);
        }
        return null;
    }

    private static Area getArea(BlockPos pos, Direction hitFace) {
        int face = hitFace.get3DDataValue();
        Vec3 right = GeometryHelper.FACE_RIGHT[face];
        int rx = (int)right.x();
        int ry = (int)right.y();
        int rz = (int)right.z();
        Vec3 up = GeometryHelper.FACE_UP[face];
        int ux = (int)up.x();
        int uy = (int)up.y();
        int uz = (int)up.z();
        return new Area(pos, pos.offset(rx + ux, ry + uy, rz + uz), pos.offset(-rx - ux, -ry - uy, -rz - uz));
    }

    public static void forEachMineableBlock(BlockGetter world, Area area, LivingEntity miner, BiConsumer<BlockPos, BlockState> callback) {
        BlockPos.betweenClosed((BlockPos)area.corner1(), (BlockPos)area.corner2()).forEach(blockPos -> {
            if (world.getBlockEntity(blockPos) != null && !area.center().equals(blockPos)) {
                return;
            }
            if (!(miner instanceof Player)) {
                return;
            }
            BlockState tempState = world.getBlockState(blockPos);
            if (tempState.isAir()) {
                return;
            }
            if (!tempState.is(BlockTags.MINEABLE_WITH_PICKAXE) && !tempState.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
                return;
            }
            if (tempState.getDestroySpeed(world, blockPos) < 0.0f) {
                return;
            }
            callback.accept((BlockPos)blockPos, tempState);
        });
    }

    private static HitResult rayTraceSimple(BlockGetter world, Player living, float partialTicks) {
        double blockReachDistance = living.getBlockReach();
        Vec3 vec3d = living.getEyePosition(partialTicks);
        Vec3 vec3d1 = living.getViewVector(partialTicks);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * blockReachDistance, vec3d1.y * blockReachDistance, vec3d1.z * blockReachDistance);
        return world.clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living));
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        this.useFuel(stack, miner);
        if (!(miner instanceof Player)) {
            return false;
        }
        Player p = (Player)miner;
        Area area = SteamDrillItem.getArea((BlockGetter)world, p);
        if (area == null) {
            return false;
        }
        ArrayList totalDrops = new ArrayList();
        SteamDrillItem.forEachMineableBlock((BlockGetter)world, area, miner, (blockPos, tempState) -> {
            Block block = tempState.getBlock();
            int xp = CommonHooks.onBlockBreakEvent((Level)world, (GameType)((ServerPlayer)miner).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)miner), (BlockPos)blockPos);
            BlockEntity blockEntity = world.getBlockEntity(blockPos);
            if (xp >= 0 && block.onDestroyedByPlayer(tempState, world, blockPos, (Player)miner, true, tempState.getFluidState())) {
                block.destroy((LevelAccessor)world, blockPos, tempState);
                Block.getDrops((BlockState)tempState, (ServerLevel)((ServerLevel)world), (BlockPos)blockPos, (BlockEntity)blockEntity, (Entity)miner, (ItemStack)stack).forEach(itemStack -> {
                    boolean combined = false;
                    for (ItemStack drop : totalDrops) {
                        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)drop, (ItemStack)itemStack)) continue;
                        drop.setCount(drop.getCount() + itemStack.getCount());
                        combined = true;
                        break;
                    }
                    if (!combined) {
                        totalDrops.add(itemStack);
                    }
                });
                block.popExperience((ServerLevel)world, blockPos, xp);
            }
        });
        totalDrops.forEach(itemStack -> Block.popResource((Level)world, (BlockPos)miner.blockPosition(), (ItemStack)itemStack));
        world.getEntitiesOfClass(ExperienceOrb.class, new AABB(Vec3.atLowerCornerOf((Vec3i)area.corner1()), Vec3.atLowerCornerOf((Vec3i)area.corner2())).inflate(1.0)).forEach(entityXPOrb -> entityXPOrb.teleportTo((double)miner.blockPosition().getX(), (double)miner.blockPosition().getY(), (double)miner.blockPosition().getZ()));
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useFuel(stack, attacker);
        return true;
    }

    private void useFuel(ItemStack stack, @Nullable LivingEntity entity) {
        CompoundTag tag = stack.getTag();
        if (tag != null && tag.getInt("water") > 0 && tag.getInt("burnTicks") == 0) {
            int burnTicks = this.consumeFuel(stack, Simulation.ACT);
            tag = stack.getOrCreateTag();
            tag.putInt("burnTicks", burnTicks);
            tag.putInt("maxBurnTicks", burnTicks);
            if (burnTicks > 0 && entity != null) {
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && user.isShiftKeyDown()) {
            ItemStack stack = user.getItemInHand(hand);
            SteamDrillItem.setSilkTouch(stack, SteamDrillItem.isNotSilkTouch(stack));
            if (!world.isClientSide) {
                user.displayClientMessage((Component)(SteamDrillItem.isNotSilkTouch(stack) ? MIText.ToolSwitchedNoSilkTouch.text() : MIText.ToolSwitchedSilkTouch.text()), true);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        ItemStack itemStack = user.getItemInHand(hand);
        BlockHitResult hitResult = SteamDrillItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        FluidState fluidState = world.getFluidState(hitResult.getBlockPos());
        if (fluidState.getType() == Fluids.WATER || fluidState.getType() == Fluids.FLOWING_WATER) {
            this.fillWater(user, itemStack);
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
        }
        return super.use(world, user, hand);
    }

    private void fillWater(Player player, ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        if (tag.getInt("water") != 18000) {
            tag.putInt("water", 18000);
            player.playNotifySound(SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        CompoundTag tag = stack.getOrCreateTag();
        int burnTicks = tag.getInt("burnTicks");
        if (burnTicks > 0) {
            NbtHelper.putNonzeroInt(tag, "burnTicks", Math.max(0, burnTicks - 5));
            NbtHelper.putNonzeroInt(tag, "water", Math.max(0, tag.getInt("water") - 5));
        }
        if (tag.getInt("burnTicks") == 0) {
            tag.remove("maxBurnTicks");
        }
        if (tag.getInt("water") == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            Inventory inv = player.getInventory();
            for (int i = 0; i < inv.getContainerSize() && !this.tryFillWater(player, stack, inv.getItem(i)); ++i) {
            }
        }
    }

    public boolean canUse(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        if (tag == null || tag.getInt("water") == 0) {
            return false;
        }
        return tag.getInt("burnTicks") > 0 || this.consumeFuel(stack, Simulation.SIMULATE) > 0;
    }

    private int consumeFuel(ItemStack stack, Simulation simulation) {
        int burnTicks = CommonHooks.getBurnTime((ItemStack)this.getResource(stack).toStack(), null);
        if (burnTicks > 0) {
            if (simulation.isActing()) {
                ItemStack burnt = this.getResource(stack).toStack();
                this.setAmount(stack, this.getAmount(stack) - 1L);
                if (burnt.hasCraftingRemainingItem()) {
                    new ContainerItem.ItemHandler(stack, this).insertItem(0, burnt.getCraftingRemainingItem(), false, true, true);
                }
            }
            return burnTicks;
        }
        return 0;
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return this.getAllEnchantments(stack).getOrDefault(enchantment, 0);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Reference2IntOpenHashMap map = new Reference2IntOpenHashMap();
        if (!SteamDrillItem.isNotSilkTouch(stack)) {
            map.put((Object)Enchantments.SILK_TOUCH, 1);
        }
        return map;
    }

    public boolean isFoil(ItemStack pStack) {
        return !this.getAllEnchantments(pStack).isEmpty();
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        if (tag != null) {
            return Optional.of(new SteamDrillTooltipData(tag.getInt("water") * 100 / 18000, tag.getInt("burnTicks"), tag.getInt("maxBurnTicks"), this.getResource(stack), this.getAmount(stack)));
        }
        return Optional.of(new SteamDrillTooltipData(0, 0, 1, ItemVariant.blank(), 0L));
    }

    public boolean overrideStackedOnOther(ItemStack stackBarrel, Slot slot, ClickAction clickType, Player player) {
        return this.handleStackedOnOther(stackBarrel, slot, clickType, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stackBarrel, ItemStack itemStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        return this.handleOtherStackedOnMe(stackBarrel, itemStack, slot, clickType, player, cursorStackReference);
    }

    @Override
    public boolean handleClick(Player player, ItemStack barrelLike, Mutable<ItemStack> otherStack) {
        if (this.tryFillWater(player, barrelLike, (ItemStack)otherStack.getValue())) {
            return true;
        }
        return ItemContainingItemHelper.super.handleClick(player, barrelLike, otherStack);
    }

    private boolean tryFillWater(Player player, ItemStack barrelLike, ItemStack fillSource) {
        IFluidHandlerItem otherStorage = (IFluidHandlerItem)fillSource.getCapability(Capabilities.FluidHandler.ITEM);
        if (otherStorage != null) {
            long totalWater = 0L;
            for (int tank = 0; tank < otherStorage.getTanks(); ++tank) {
                if (otherStorage.getFluidInTank(tank).getFluid() != Fluids.WATER) continue;
                totalWater += (long)otherStorage.getFluidInTank(tank).getAmount();
            }
            if (totalWater * (long)fillSource.getCount() >= 1000L) {
                this.fillWater(player, barrelLike);
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        SteamDrillTooltipData data = (SteamDrillTooltipData)this.getTooltipImage(stack).get();
        tooltip.add((Component)MIText.WaterPercent.text(data.waterLevel).setStyle(TextHelper.WATER_TEXT));
        int barWater = (int)Math.ceil((double)data.waterLevel / 5.0);
        int barVoid = 20 - barWater;
        tooltip.add((Component)Component.literal((String)"|".repeat(barWater)).setStyle(TextHelper.WATER_TEXT).append((Component)Component.literal((String)"|".repeat(barVoid)).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x6B6B6B)))));
        if (data.burnTicks > 0) {
            tooltip.add((Component)MIText.SecondsLeft.text(data.burnTicks / 100).setStyle(TextHelper.GRAY_TEXT));
        }
        if (!SteamDrillItem.isNotSilkTouch(stack)) {
            tooltip.add(Enchantments.SILK_TOUCH.getFullname(1));
        }
    }

    @Override
    public StorageBehaviour<ItemVariant> getBehaviour() {
        return DRILL_BEHAVIOUR;
    }

    public record Area(BlockPos center, BlockPos corner1, BlockPos corner2) {
    }

    public record SteamDrillTooltipData(int waterLevel, int burnTicks, int maxBurnTicks, ItemVariant variant, long amount) implements TooltipComponent
    {
    }
}

