/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.items.armor.ActivatableChestItem;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class GraviChestPlateItem
extends ArmorItem
implements ActivatableChestItem,
ISimpleEnergyItem {
    public static final long FLIGHT_COST = 1024L;
    public static final long ENERGY_CAPACITY = 0x1000000L;

    public GraviChestPlateItem(Item.Properties settings) {
        super(GraviChestPlateItem.buildMaterial(), ArmorItem.Type.CHESTPLATE, settings.stacksTo(1).rarity(Rarity.EPIC));
    }

    private static ArmorMaterial buildMaterial() {
        return new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return 0;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return 0;
            }

            public int getEnchantmentValue() {
                return 0;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.ARMOR_EQUIP_GENERIC;
            }

            public Ingredient getRepairIngredient() {
                return null;
            }

            public String getName() {
                return "modern_industrialization:gravichestplate";
            }

            public float getToughness() {
                return 0.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }

            public String toString() {
                return this.getName().replace("/", ":");
            }
        };
    }

    public long getEnergy(ItemStack stack) {
        return this.getStoredEnergy(stack);
    }

    public void setEnergy(ItemStack stack, long energy) {
        this.setStoredEnergy(stack, energy);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        if (level.isClientSide()) {
            return;
        }
        if (entity instanceof Player && stack == (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST) && player.getAbilities().flying) {
            this.setEnergy(stack, Math.max(0L, this.getEnergy(stack) - 1024L));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round((double)this.getEnergy(stack) / 1.6777216E7 * 13.0);
    }

    public long getEnergyCapacity(ItemStack stack) {
        return 0x1000000L;
    }

    public long getEnergyMaxInput(ItemStack stack) {
        return 0x1000000L;
    }

    public long getEnergyMaxOutput(ItemStack stack) {
        return 0L;
    }
}

