/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.armor.GraviChestPlateItem;
import aztech.modern_industrialization.items.armor.QuantumArmorItem;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;

public class MIArmorEffects {
    private MIArmorEffects() {
    }

    public static boolean quantumArmorPreventsDamage(LivingEntity entity) {
        int parts = 0;
        for (QuantumArmorItem item : QuantumArmorItem.ITEMS) {
            if (entity.getItemBySlot(item.getType().getSlot()).getItem() != item) continue;
            ++parts;
        }
        return ThreadLocalRandom.current().nextDouble() < (double)parts / 4.0;
    }

    public static boolean allowFlight(Player player) {
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        return MIArmorEffects.allowFlight(chest);
    }

    public static boolean allowFlight(ItemStack chest) {
        GraviChestPlateItem gsp;
        Item item = chest.getItem();
        if (item instanceof GraviChestPlateItem && (gsp = (GraviChestPlateItem)item).isActivated(chest) && gsp.getEnergy(chest) > 0L) {
            return true;
        }
        return chest.getItem() == MIItem.QUANTUM_CHESTPLATE.asItem();
    }

    public static boolean canTankFlyIntoWall(ItemStack helmet) {
        return helmet.getItem() == MIItem.RUBBER_HELMET.asItem() || helmet.getItem() == MIItem.QUANTUM_HELMET.asItem();
    }

    public static boolean canTankFall(ItemStack boots) {
        return boots.getItem() == MIItem.RUBBER_BOOTS.asItem() || boots.getItem() == MIItem.QUANTUM_BOOTS.asItem();
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(TickEvent.PlayerTickEvent.class, event -> {
            if (event.phase == TickEvent.Phase.START && event.side.isServer() && MIArmorEffects.allowFlight(event.player)) {
                event.player.getAbilities().mayfly = true;
                event.player.onUpdateAbilities();
            }
        });
        NeoForge.EVENT_BUS.addListener(LivingEquipmentChangeEvent.class, event -> {
            LivingEntity patt3786$temp;
            if (event.getSlot() == EquipmentSlot.CHEST && MIArmorEffects.allowFlight(event.getFrom()) && !MIArmorEffects.allowFlight(event.getTo()) && (patt3786$temp = event.getEntity()) instanceof Player) {
                Player player = (Player)patt3786$temp;
                player.getAbilities().mayfly = false;
                player.getAbilities().flying = false;
                player.onUpdateAbilities();
            }
        });
        NeoForge.EVENT_BUS.addListener(LivingDamageEvent.class, event -> {
            ItemStack head;
            LivingEntity entity = event.getEntity();
            DamageSource source = event.getSource();
            float amount = event.getAmount();
            if (MIArmorEffects.quantumArmorPreventsDamage(entity)) {
                event.setCanceled(true);
                return;
            }
            ItemStack tankingStack = null;
            EquipmentSlot es = null;
            if (source.is(DamageTypes.FLY_INTO_WALL)) {
                es = EquipmentSlot.HEAD;
                head = entity.getItemBySlot(es);
                if (MIArmorEffects.canTankFlyIntoWall(head)) {
                    tankingStack = head;
                }
            } else if (source.is(DamageTypes.FALL) && MIArmorEffects.canTankFall(head = entity.getItemBySlot(es = EquipmentSlot.FEET))) {
                tankingStack = head;
            }
            if (tankingStack != null) {
                int intAmount = (int)Math.ceil(amount);
                EquipmentSlot equipmentSlot = es;
                tankingStack.hurtAndBreak(intAmount, entity, p -> entity.broadcastBreakEvent(equipmentSlot));
                event.setCanceled(true);
            }
        });
    }
}

