/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class QuantumArmorItem
extends ArmorItem {
    public static final List<QuantumArmorItem> ITEMS = new ArrayList<QuantumArmorItem>();
    private static final ArmorMaterial MATERIAL = new ArmorMaterial(){

        public int getDurabilityForType(ArmorItem.Type type) {
            return 0;
        }

        public int getDefenseForType(ArmorItem.Type type) {
            return 0;
        }

        public int getEnchantmentValue() {
            return 0;
        }

        public SoundEvent getEquipSound() {
            return SoundEvents.ARMOR_EQUIP_GENERIC;
        }

        public Ingredient getRepairIngredient() {
            return null;
        }

        public String getName() {
            return "modern_industrialization:quantum";
        }

        public float getToughness() {
            return 0.0f;
        }

        public float getKnockbackResistance() {
            return 0.0f;
        }

        public String toString() {
            return this.getName().replace("/", ":");
        }
    };

    public QuantumArmorItem(ArmorItem.Type type, Item.Properties settings) {
        super(MATERIAL, type, settings);
        ITEMS.add(this);
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot slot) {
        return ImmutableMultimap.of();
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag context) {
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)("item.modifiers." + this.getType().getSlot().getName())).withStyle(ChatFormatting.GRAY));
        String oneQuarterInfinity = " \u00b9\u2044\u2084 |\u221e> + \u00b3\u2044\u2084 |0>";
        list.add((Component)Component.translatable((String)"attribute.modifier.plus.0", (Object[])new Object[]{oneQuarterInfinity, Component.translatable((String)"attribute.name.generic.armor")}).withStyle(ChatFormatting.BLUE));
    }
}

