/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.diesel_tools;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.datamaps.FluidFuel;
import aztech.modern_industrialization.fluid.MIFluid;
import aztech.modern_industrialization.items.DynamicToolItem;
import aztech.modern_industrialization.items.FluidFuelItemHelper;
import aztech.modern_industrialization.items.ItemHelper;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.TierSortingRegistry;

public class DieselToolItem
extends Item
implements Vanishable,
DynamicToolItem {
    public static final int CAPACITY = 4000;
    private final double damage;

    public DieselToolItem(Item.Properties settings, double damage) {
        super(settings.stacksTo(1).rarity(Rarity.UNCOMMON));
        this.damage = damage;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (state.getDestroySpeed((BlockGetter)world, pos) != 0.0f) {
            FluidFuelItemHelper.decrement(stack);
        }
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        FluidFuelItemHelper.decrement(stack);
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (this.isSupportedBlock(stack, state) && FluidFuelItemHelper.getAmount(stack) > 0 && TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.NETHERITE, (BlockState)state)) {
            return true;
        }
        return super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.isSupportedBlock(stack, state)) {
            return this.getMiningSpeedMultiplier(stack);
        }
        return 1.0f;
    }

    private float getMiningSpeedMultiplier(ItemStack stack) {
        FluidVariant fluid;
        int burnTicks;
        long amount = FluidFuelItemHelper.getAmount(stack);
        if (amount > 0L && (burnTicks = FluidFuel.getEu((fluid = FluidFuelItemHelper.getFluid(stack)).getFluid())) > 0) {
            return 1.0f + (float)burnTicks / 8.0f;
        }
        return 1.0f;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND && FluidFuelItemHelper.getAmount(stack) > 0) {
            return ItemHelper.createToolModifiers(this.damage * (double)FluidFuel.getEu(FluidFuelItemHelper.getFluid(stack).getFluid()) / 600.0);
        }
        return ImmutableMultimap.of();
    }

    public void appendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        FluidFuelItemHelper.appendTooltip(stack, tooltip, 4000L);
        for (Map.Entry<Enchantment, Integer> entry : this.getAllEnchantments(stack).entrySet()) {
            tooltip.add(entry.getKey().getFullname(entry.getValue().intValue()));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round(this.getDurabilityBarProgress(stack) * 13.0);
    }

    public int getBarColor(ItemStack stack) {
        Fluid fluid = FluidFuelItemHelper.getFluid(stack).getFluid();
        if (fluid instanceof MIFluid) {
            MIFluid cf = (MIFluid)fluid;
            return cf.color;
        }
        return 0;
    }

    public double getDurabilityBarProgress(ItemStack stack) {
        return (double)FluidFuelItemHelper.getAmount(stack) / 4000.0;
    }

    private static boolean isFortune(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        return tag != null && tag.getBoolean("fortune");
    }

    private static void setFortune(ItemStack stack, boolean fortune) {
        if (fortune) {
            stack.getOrCreateTag().putBoolean("fortune", true);
        } else {
            stack.removeTagKey("fortune");
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && user.isShiftKeyDown()) {
            ItemStack stack;
            DieselToolItem.setFortune(stack, !DieselToolItem.isFortune(stack = user.getItemInHand(hand)));
            if (!world.isClientSide) {
                user.displayClientMessage((Component)(DieselToolItem.isFortune(stack) ? MIText.ToolSwitchedFortune.text() : MIText.ToolSwitchedSilkTouch.text()), true);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        return super.use(world, user, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level w = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = w.getBlockState(pos);
        Player player = context.getPlayer();
        if (FluidFuelItemHelper.getAmount(stack) > 0) {
            BlockState newState;
            Block newBlock;
            if (stack.is(ItemTags.AXES) && (newBlock = StrippingAccess.getStrippedBlocks().get(state.getBlock())) != null) {
                w.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!w.isClientSide) {
                    w.setBlock(pos, (BlockState)newBlock.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))), 11);
                    FluidFuelItemHelper.decrement(stack);
                }
                return InteractionResult.sidedSuccess((boolean)w.isClientSide);
            }
            if (stack.is(ItemTags.SHOVELS) && (newState = PathingAccess.getPathStates().get(state.getBlock())) != null) {
                w.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!w.isClientSide) {
                    w.setBlock(pos, newState, 11);
                    FluidFuelItemHelper.decrement(stack);
                }
                return InteractionResult.sidedSuccess((boolean)w.isClientSide);
            }
            if (stack.is(ItemTags.HOES)) {
                // empty if block
            }
        }
        return super.useOn(context);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return this.getAllEnchantments(stack).getOrDefault(enchantment, 0);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Reference2IntArrayMap map = new Reference2IntArrayMap();
        if (FluidFuelItemHelper.getAmount(stack) > 0) {
            if (!DieselToolItem.isFortune(stack)) {
                map.put((Object)Enchantments.SILK_TOUCH, Enchantments.SILK_TOUCH.getMaxLevel());
            } else {
                map.put((Object)Enchantments.BLOCK_FORTUNE, Enchantments.BLOCK_FORTUNE.getMaxLevel());
            }
        }
        return map;
    }

    public boolean isFoil(ItemStack pStack) {
        return !this.getAllEnchantments(pStack).isEmpty();
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        int defaultMb = 100;
        float speedMultiplier = this.getMiningSpeedMultiplier(stack);
        int costMb = (int)(100.0f / speedMultiplier);
        if (FluidFuelItemHelper.getAmount(stack) >= costMb && stack.is(Tags.Items.SHEARS) && interactionTarget instanceof Shearable) {
            Shearable shearable = (Shearable)interactionTarget;
            if (!interactionTarget.level().isClientSide && shearable.readyForShearing()) {
                shearable.shear(SoundSource.PLAYERS);
                interactionTarget.gameEvent(GameEvent.SHEAR, (Entity)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static class StrippingAccess
    extends AxeItem {
        private StrippingAccess(Tier material, float attackDamage, float attackSpeed, Item.Properties settings) {
            super(material, attackDamage, attackSpeed, settings);
        }

        public static Map<Block, Block> getStrippedBlocks() {
            return STRIPPABLES;
        }
    }

    private static class PathingAccess
    extends ShovelItem {
        private PathingAccess(Tier material, float attackDamage, float attackSpeed, Item.Properties settings) {
            super(material, attackDamage, attackSpeed, settings);
        }

        public static Map<Block, BlockState> getPathStates() {
            return FLATTENABLES;
        }
    }
}

