/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public abstract class AbstractWaterPumpBlockEntity
extends MachineBlockEntity
implements Tickable {
    protected static final int OUTPUT_SLOT_X = 110;
    protected static final int OUTPUT_SLOT_Y = 30;
    private static final ProgressBar.Parameters PROGRESS_BAR = new ProgressBar.Parameters(79, 29, "extract");
    private static final int OPERATION_TICKS = 100;
    protected int pumpingTicks = 0;
    protected IsActiveComponent isActiveComponent = new IsActiveComponent();
    private static final int[] DX = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
    private static final int[] DZ = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};

    public AbstractWaterPumpBlockEntity(BEP bep, String blockName) {
        super(bep, new MachineGuiParameters.Builder(blockName, false).build(), new OrientationComponent.Params(true, false, false));
        this.registerGuiComponent(new ProgressBar.Server(PROGRESS_BAR, () -> Float.valueOf((float)this.pumpingTicks / 100.0f)));
        this.registerComponents(this.isActiveComponent, new IComponent(){

            @Override
            public void writeNbt(CompoundTag tag) {
                tag.putInt("pumpingTicks", AbstractWaterPumpBlockEntity.this.pumpingTicks);
            }

            @Override
            public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
                AbstractWaterPumpBlockEntity.this.pumpingTicks = tag.getInt("pumpingTicks");
            }
        });
    }

    protected abstract long consumeEu(long var1);

    protected abstract int getWaterMultiplier();

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            List<ConfigurableFluidStack> fluidStacks = this.getInventory().getFluidStacks();
            ConfigurableFluidStack waterStack = fluidStacks.get(fluidStacks.size() - 1);
            if (waterStack.getRemainingSpace() < 125L) {
                this.updateActive(false);
            } else {
                long eu = this.consumeEu(1L);
                this.pumpingTicks = (int)((long)this.pumpingTicks + eu);
                this.updateActive(eu > 0L);
                if (this.pumpingTicks == 100) {
                    waterStack.setKey(FluidVariant.of((Fluid)Fluids.WATER));
                    waterStack.increment(Math.min((long)this.getWaterMultiplier() * (long)this.getWaterSourceCount() * 1000L / 8L, waterStack.getRemainingSpace()));
                    this.pumpingTicks = 0;
                }
            }
            this.getInventory().autoExtractFluids(this.level, this.worldPosition, this.orientation.outputDirection);
            this.setChanged();
        }
    }

    private void updateActive(boolean newActive) {
        this.isActiveComponent.updateActive(newActive, this);
    }

    private int getWaterSourceCount() {
        boolean[] adjWater = new boolean[]{false, false, false, false, false, false, false, false};
        for (int i = 0; i < 8; ++i) {
            BlockPos adjPos = this.worldPosition.offset(DX[i], 0, DZ[i]);
            FluidState adjState = this.level.getFluidState(adjPos);
            if (!adjState.isSource() || adjState.getType() != Fluids.WATER) continue;
            adjWater[i] = true;
        }
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            if (!adjWater[i] || i % 2 != 1 && !adjWater[(i + 7) % 8] && !adjWater[(i + 1) % 8]) continue;
            ++count;
        }
        return count;
    }
}

