/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.AbstractCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.LubricantHelper;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ElectricCraftingMachineBlockEntity
extends AbstractCraftingMachineBlockEntity
implements EnergyComponentHolder {
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final CasingComponent casing = new CasingComponent();
    private final UpgradeComponent upgrades = new UpgradeComponent();
    private final EnergyComponent energy = new EnergyComponent((BlockEntity)this, this.casing::getEuCapacity);
    private final MIEnergyStorage insertable = this.energy.buildInsertable(cableTier -> this.casing.canInsertEu((CableTier)cableTier));

    public ElectricCraftingMachineBlockEntity(BEP bep, MachineRecipeType recipeType, MachineInventoryComponent inventory, MachineGuiParameters guiParams, EnergyBar.Parameters energyBarParams, ProgressBar.Parameters progressBarParams, RecipeEfficiencyBar.Parameters efficiencyBarParams, MachineTier tier, long euCapacity) {
        super(bep, recipeType, inventory, guiParams, progressBarParams, tier);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(energyBarParams, this.energy::getEu, this.energy::getCapacity);
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new RecipeEfficiencyBar.Server(efficiencyBarParams, this.crafter));
        this.registerGuiComponent(new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades).withCasing(this.casing));
        this.registerComponents(this.redstoneControl, this.casing, this.upgrades, this.energy);
    }

    @Override
    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation(this);
    }

    @Override
    public long consumeEu(long max, Simulation simulation) {
        return this.energy.consumeEu(max, simulation);
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.casing.getCasing());
        this.orientation.writeModelData(data);
        data.isActive = this.isActiveComponent.isActive;
        return data;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((ElectricCraftingMachineBlockEntity)be).insertable));
    }

    @Override
    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse(this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.casing.onUse(this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.upgrades.onUse(this, player, hand);
        }
        if (!result.consumesAction()) {
            result = LubricantHelper.onUse(this.crafter, player, hand);
        }
        return result;
    }

    @Override
    public long getMaxRecipeEu() {
        return (long)this.tier.getMaxEu() + this.upgrades.getAddMaxEUPerTick();
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }
}

