/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.AbstractCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGui;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;

public class SteamCraftingMachineBlockEntity
extends AbstractCraftingMachineBlockEntity {
    private final OverclockComponent overclockComponent;

    public SteamCraftingMachineBlockEntity(BEP bep, MachineRecipeType recipeType, MachineInventoryComponent inventory, MachineGuiParameters guiParams, ProgressBar.Parameters progressBarParams, MachineTier tier, List<OverclockComponent.Catalyst> overclockCatalysts) {
        super(bep, recipeType, inventory, guiParams, progressBarParams, tier);
        this.overclockComponent = new OverclockComponent(overclockCatalysts);
        GunpowderOverclockGui.Parameters gunpowderOverclockGuiParams = new GunpowderOverclockGui.Parameters(progressBarParams.renderX, progressBarParams.renderY + 20);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new GunpowderOverclockGui.Server(gunpowderOverclockGuiParams, this.overclockComponent::getTicks);
        this.registerGuiComponent(serverArray);
        this.registerComponents(this.overclockComponent);
    }

    @Override
    public long consumeEu(long max, Simulation simulation) {
        return SteamHelper.consumeSteamEu(this.getInventory().getFluidStacks(), max, simulation);
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        data.isActive = this.isActiveComponent.isActive;
        return data;
    }

    @Override
    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        if (!result.consumesAction()) {
            return this.overclockComponent.onUse(this, player, hand);
        }
        return result;
    }

    @Override
    public long getMaxRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getMaxEu());
    }

    @Override
    public long getBaseRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getBaseEu());
    }

    @Override
    public void tick() {
        super.tick();
        this.overclockComponent.tick(this);
    }

    @Override
    public List<Component> getTooltips() {
        return this.overclockComponent.getTooltips();
    }
}

