/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.hatches;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import java.util.List;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EnergyHatch
extends HatchBlockEntity
implements EnergyComponentHolder {
    private final boolean input;
    protected final EnergyComponent energy;
    protected final MIEnergyStorage insertable;
    protected final MIEnergyStorage extractable;

    public EnergyHatch(BEP bep, String name, boolean input, CableTier tier) {
        super(bep, new MachineGuiParameters.Builder(name, false).build(), new OrientationComponent.Params(!input, false, false));
        this.input = input;
        this.energy = new EnergyComponent((BlockEntity)this, 600L * tier.getEu());
        this.insertable = this.energy.buildInsertable(tier2 -> tier2 == tier);
        this.extractable = this.energy.buildExtractable(tier2 -> tier2 == tier);
        EnergyBar.Parameters energyBarParams = new EnergyBar.Parameters(76, 39);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(energyBarParams, this.energy::getEu, this.energy::getCapacity);
        this.registerGuiComponent(serverArray);
        this.registerComponents(this.energy);
    }

    @Override
    public HatchType getHatchType() {
        return this.input ? HatchType.ENERGY_INPUT : HatchType.ENERGY_OUTPUT;
    }

    @Override
    public boolean upgradesToSteel() {
        return false;
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }

    @Override
    public void appendEnergyInputs(List<EnergyComponent> list) {
        if (this.input) {
            list.add(this.energy);
        }
    }

    @Override
    public void appendEnergyOutputs(List<EnergyComponent> list) {
        if (!this.input) {
            list.add(this.energy);
        }
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> {
            EnergyHatch eh = (EnergyHatch)be;
            if (eh.input) {
                return eh.insertable;
            }
            if (eh.orientation.outputDirection == direction) {
                return eh.extractable;
            }
            return null;
        }));
    }
}

