/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.LubricantHelper;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractElectricCraftingMultiblockBlockEntity
extends AbstractCraftingMultiblockBlockEntity
implements EnergyListComponentHolder,
CrafterComponent.Behavior {
    protected final RedstoneControlComponent redstoneControl;
    protected final List<EnergyComponent> energyInputs = new ArrayList<EnergyComponent>();

    public AbstractElectricCraftingMultiblockBlockEntity(BEP bep, String name, OrientationComponent.Params orientationParams, ShapeTemplate[] shapeTemplates) {
        super(bep, name, orientationParams, shapeTemplates);
        this.redstoneControl = new RedstoneControlComponent();
        this.registerComponents(this.redstoneControl);
    }

    public List<EnergyComponent> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    protected void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.energyInputs.clear();
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            hatch.appendEnergyInputs(this.energyInputs);
        }
    }

    @Override
    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        if (!result.consumesAction()) {
            result = LubricantHelper.onUse(this.crafter, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.mapComponentOrDefault(UpgradeComponent.class, upgrade -> upgrade.onUse(this, player, hand), result);
        }
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse(this, player, hand);
        }
        return result;
    }

    @Override
    protected final CrafterComponent.Behavior getBehavior() {
        return this;
    }

    @Override
    public final boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation(this);
    }

    @Override
    public final long consumeEu(long max, Simulation simulation) {
        long total = 0L;
        for (EnergyComponent energyComponent : this.energyInputs) {
            total += energyComponent.consumeEu(max - total, simulation);
        }
        return total;
    }

    @Override
    public final Level getCrafterWorld() {
        return this.level;
    }

    @Override
    @Nullable
    public final UUID getOwnerUuid() {
        return this.placedBy.placerId;
    }
}

