/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SteamCraftingMultiblockBlockEntity
extends AbstractCraftingMultiblockBlockEntity {
    private final OverclockComponent overclockComponent;
    private final MachineRecipeType recipeType;
    private boolean steelTier;

    public SteamCraftingMultiblockBlockEntity(BEP bep, String name, ShapeTemplate shapeTemplate, MachineRecipeType recipeType, List<OverclockComponent.Catalyst> overclockCatalysts) {
        super(bep, name, new OrientationComponent.Params(false, false, false), new ShapeTemplate[]{shapeTemplate});
        this.overclockComponent = new OverclockComponent(overclockCatalysts);
        this.recipeType = recipeType;
        this.registerComponents(this.overclockComponent);
    }

    @Override
    protected CrafterComponent.Behavior getBehavior() {
        return new Behavior();
    }

    @Override
    protected void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.steelTier = false;
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            if (!hatch.upgradesToSteel()) continue;
            this.steelTier = true;
        }
    }

    @Override
    public List<Component> getTooltips() {
        return this.overclockComponent.getTooltips();
    }

    @Override
    public final void tickExtra() {
        this.overclockComponent.tick(this);
    }

    @Override
    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        if (!result.consumesAction()) {
            return this.overclockComponent.onUse(this, player, hand);
        }
        return result;
    }

    private class Behavior
    implements CrafterComponent.Behavior {
        private Behavior() {
        }

        @Override
        public long consumeEu(long max, Simulation simulation) {
            return SteamHelper.consumeSteamEu(SteamCraftingMultiblockBlockEntity.this.inventory.getFluidInputs(), max, simulation);
        }

        @Override
        public MachineRecipeType recipeType() {
            return SteamCraftingMultiblockBlockEntity.this.recipeType;
        }

        @Override
        public long getBaseRecipeEu() {
            return SteamCraftingMultiblockBlockEntity.this.overclockComponent.getRecipeEu(SteamCraftingMultiblockBlockEntity.this.steelTier ? 4 : 2);
        }

        @Override
        public long getMaxRecipeEu() {
            return this.getBaseRecipeEu();
        }

        @Override
        public Level getCrafterWorld() {
            return SteamCraftingMultiblockBlockEntity.this.level;
        }

        @Override
        @Nullable
        public UUID getOwnerUuid() {
            return SteamCraftingMultiblockBlockEntity.this.placedBy.placerId;
        }
    }
}

