/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.DropableComponent;
import aztech.modern_industrialization.machines.models.MachineCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CasingComponent
implements IComponent,
DropableComponent {
    private ItemStack casingStack = ItemStack.EMPTY;
    private CableTier currentTier = CableTier.LV;

    private void setCasingStack(ItemStack stack) {
        this.casingStack = stack;
        this.currentTier = CasingComponent.getCasingTier(stack.getItem());
        if (this.currentTier == null) {
            this.currentTier = CableTier.LV;
        }
    }

    @Override
    public void writeNbt(CompoundTag tag) {
        tag.put("casing", (Tag)this.casingStack.save(new CompoundTag()));
    }

    @Override
    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        if (tag.contains("casing", 8)) {
            CableTier tier = CableTier.getTier(tag.getString("casing"));
            this.setCasingStack(((Item)BuiltInRegistries.ITEM.get(tier.itemKey)).getDefaultInstance());
        } else {
            this.setCasingStack(ItemStack.of((CompoundTag)tag.getCompound("casing")));
        }
    }

    @Override
    public void writeClientNbt(CompoundTag tag) {
        tag.putString("casing", this.currentTier.name);
    }

    @Override
    public void readClientNbt(CompoundTag tag) {
        this.currentTier = CableTier.getTier(tag.getString("casing"));
    }

    public void dropCasing(Level world, BlockPos pos) {
        Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.casingStack);
    }

    public InteractionResult onUse(MachineBlockEntity be, Player player, InteractionHand hand) {
        CableTier newTier;
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.getCount() >= 1 && (newTier = CasingComponent.getCasingTier(stackInHand.getItem())) != null && newTier != this.currentTier) {
            if (this.currentTier != CableTier.LV) {
                this.dropCasing(be.getLevel(), be.getBlockPos());
            }
            this.setCasingStack(stackInHand.copyWithCount(1));
            if (!player.isCreative()) {
                stackInHand.shrink(1);
            }
            be.setChanged();
            if (!be.getLevel().isClientSide()) {
                be.sync();
            }
            be.getLevel().updateNeighborsAt(be.getBlockPos(), Blocks.AIR);
            this.playCasingPlaceSound(be);
            return InteractionResult.sidedSuccess((boolean)be.getLevel().isClientSide);
        }
        return InteractionResult.PASS;
    }

    private void playCasingPlaceSound(MachineBlockEntity be) {
        ResourceLocation blockKey = this.currentTier.itemKey;
        if (blockKey == null) {
            return;
        }
        BuiltInRegistries.BLOCK.getOptional(blockKey).ifPresent(block -> {
            BlockState casingState = block.defaultBlockState();
            SoundType group = casingState.getSoundType();
            SoundEvent sound = group.getBreakSound();
            be.getLevel().playSound(null, be.getBlockPos(), sound, SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 4.0f, group.getPitch() * 0.8f);
        });
    }

    @Nullable
    public static CableTier getCasingTier(Item item) {
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)item);
        for (CableTier tier : CableTier.allTiers()) {
            if (tier.itemKey == null || !tier.itemKey.equals((Object)itemKey)) continue;
            return tier;
        }
        return null;
    }

    @Override
    public ItemStack getDrop() {
        return this.casingStack;
    }

    public void setCasingServer(MachineBlockEntity be, ItemStack casing) {
        this.setCasingStack(casing);
        be.setChanged();
        be.sync();
        be.getLevel().updateNeighborsAt(be.getBlockPos(), Blocks.AIR);
        this.playCasingPlaceSound(be);
    }

    public MachineCasing getCasing() {
        return this.currentTier.casing;
    }

    public boolean canInsertEu(CableTier tier) {
        return tier == this.currentTier;
    }

    public long getEuCapacity() {
        return this.currentTier.getEu() * 100L;
    }
}

