/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.RedstoneControlModuleItem;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.DropableComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RedstoneControlComponent
implements IComponent.ServerOnly,
DropableComponent {
    public static final ResourceLocation ID = new MIIdentifier("redstone_control");
    private ItemStack controlModule = ItemStack.EMPTY;

    public boolean doAllowNormalOperation(MachineBlockEntity machine) {
        if (this.controlModule.isEmpty()) {
            return true;
        }
        return RedstoneControlModuleItem.isRequiresLowSignal(this.controlModule) != machine.hasRedstoneHighSignal();
    }

    @Override
    public void writeNbt(CompoundTag tag) {
        tag.put("redstoneModuleStack", (Tag)this.controlModule.save(new CompoundTag()));
    }

    @Override
    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        this.controlModule = ItemStack.of((CompoundTag)tag.getCompound("redstoneModuleStack"));
    }

    public InteractionResult onUse(MachineBlockEntity be, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (MIItem.REDSTONE_CONTROL_MODULE.is(stackInHand) && this.controlModule.isEmpty()) {
            this.controlModule = stackInHand.copy();
            this.controlModule.setCount(1);
            stackInHand.shrink(1);
            be.setChanged();
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public ItemStack getDrop() {
        return this.controlModule;
    }

    public void setStackServer(MachineBlockEntity be, ItemStack stack) {
        this.controlModule = stack;
        be.setChanged();
        be.sync();
    }
}

