/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIFluidStorage;
import aztech.modern_industrialization.machines.components.TemperatureComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SteamHeaterComponent
extends TemperatureComponent {
    private static final int STEAM_TO_WATER = 16;
    public final long maxEuProduction;
    public final long euPerDegree;
    public final boolean acceptHighPressure;
    public final boolean acceptLowPressure;
    public final boolean requiresContinuousOperation;
    public static final double INPUT_ENERGY_RATIO_FOR_STARTUP = 0.8;
    private final Reference2LongMap<Fluid> steamBuffer = new Reference2LongOpenHashMap();

    public SteamHeaterComponent(double temperatureMax, long maxEuProduction, long euPerDegree) {
        this(maxEuProduction, maxEuProduction, euPerDegree, true, false, false);
    }

    public SteamHeaterComponent(double temperatureMax, long maxEuProduction, long euPerDegree, boolean acceptLowPressure, boolean acceptHighPressure, boolean requiresContinuousOperation) {
        super(temperatureMax);
        this.maxEuProduction = maxEuProduction;
        this.euPerDegree = euPerDegree;
        this.acceptLowPressure = acceptLowPressure;
        this.acceptHighPressure = acceptHighPressure;
        this.requiresContinuousOperation = requiresContinuousOperation;
    }

    public double tick(List<ConfigurableFluidStack> fluidInputs, List<ConfigurableFluidStack> fluidOutputs) {
        double euProducedLowPressure = 0.0;
        if (this.acceptLowPressure && (euProducedLowPressure = this.tryMakeSteam(fluidInputs, fluidOutputs, (Fluid)Fluids.WATER, MIFluids.STEAM.asFluid(), 1)) == 0.0) {
            euProducedLowPressure = this.tryMakeSteam(fluidInputs, fluidOutputs, MIFluids.HEAVY_WATER.asFluid(), MIFluids.HEAVY_WATER_STEAM.asFluid(), 1);
        }
        double euProducedHighPressure = 0.0;
        if (this.acceptHighPressure && (euProducedHighPressure = this.tryMakeSteam(fluidInputs, fluidOutputs, MIFluids.HIGH_PRESSURE_WATER.asFluid(), MIFluids.HIGH_PRESSURE_STEAM.asFluid(), 8)) == 0.0) {
            euProducedHighPressure = this.tryMakeSteam(fluidInputs, fluidOutputs, MIFluids.HIGH_PRESSURE_HEAVY_WATER.asFluid(), MIFluids.HIGH_PRESSURE_HEAVY_WATER_STEAM.asFluid(), 8);
        }
        double totalEuProduced = euProducedLowPressure + euProducedHighPressure;
        if (this.requiresContinuousOperation) {
            this.decreaseTemperature(0.8 * ((double)this.maxEuProduction - totalEuProduced) / (double)this.euPerDegree);
        }
        return totalEuProduced;
    }

    private double tryMakeSteam(List<ConfigurableFluidStack> input, List<ConfigurableFluidStack> output, Fluid water, Fluid steam, int euPerSteamMb) {
        return this.tryMakeSteam(new MIFluidStorage(input), new MIFluidStorage(output), water, steam, euPerSteamMb);
    }

    private double tryMakeSteam(MIFluidStorage input, MIFluidStorage output, Fluid water, Fluid steam, int euPerSteamMb) {
        FluidVariant waterKey = FluidVariant.of(water);
        FluidVariant steamKey = FluidVariant.of(steam);
        if (this.getTemperature() > 100.0) {
            long steamProduction = (long)((this.getTemperature() - 100.0) / (this.temperatureMax - 100.0) * (double)this.maxEuProduction / (double)euPerSteamMb);
            try (Transaction tx = Transaction.openOuter();){
                long inserted;
                try (Transaction simul = Transaction.openNested(tx);){
                    inserted = output.insertAllSlot(steamKey, steamProduction, simul);
                }
                if (inserted > 0L) {
                    long waterToUse = (inserted - this.steamBuffer.getLong((Object)steam) + 16L - 1L) / 16L;
                    long extracted = input.extractAllSlot(waterKey, waterToUse, tx);
                    this.steamBuffer.mergeLong((Object)steam, extracted * 16L, Long::sum);
                    long producedSteam = output.insertAllSlot(steamKey, Math.min(steamProduction, this.steamBuffer.getLong((Object)steam)), tx);
                    this.steamBuffer.mergeLong((Object)steam, -producedSteam, Long::sum);
                    double euProduced = producedSteam * (long)euPerSteamMb;
                    this.decreaseTemperature(euProduced / (double)this.euPerDegree);
                    tx.commit();
                    double d = euProduced;
                    return d;
                }
            }
        }
        return 0.0;
    }

    @Override
    public void writeNbt(CompoundTag tag) {
        super.writeNbt(tag);
        CompoundTag buffer = new CompoundTag();
        for (Reference2LongMap.Entry entry : this.steamBuffer.reference2LongEntrySet()) {
            if (entry.getLongValue() == 0L) continue;
            buffer.putLong(((Fluid)entry.getKey()).toString(), entry.getLongValue());
        }
        tag.put("steamBuffer", (Tag)buffer);
    }

    @Override
    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        super.readNbt(tag, isUpgradingMachine);
        CompoundTag steamBuffer = tag.getCompound("steamBuffer");
        for (String key : steamBuffer.getAllKeys()) {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)key));
            if (fluid == Fluids.EMPTY) continue;
            this.steamBuffer.put((Object)fluid, steamBuffer.getLong(key));
        }
    }
}

