/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.machines.IComponent;
import net.minecraft.nbt.CompoundTag;

public class TemperatureComponent
implements IComponent {
    private double temperature;
    public final double temperatureMax;

    public TemperatureComponent(double temperatureMax) {
        this.temperatureMax = temperatureMax;
    }

    public void setTemperature(double temp) {
        this.temperature = temp;
        this.temperature = Math.min(Math.max(this.temperature, 0.0), this.temperatureMax);
    }

    public void increaseTemperature(double temp) {
        this.setTemperature(this.getTemperature() + temp);
    }

    public void decreaseTemperature(double temp) {
        this.setTemperature(this.getTemperature() - temp);
    }

    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void writeNbt(CompoundTag tag) {
        tag.putDouble("temperature", this.temperature);
    }

    @Override
    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        this.setTemperature(tag.getDouble("temperature"));
    }
}

