/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.DropableComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UpgradeComponent
implements IComponent.ServerOnly,
DropableComponent {
    private ItemStack itemStack = ItemStack.EMPTY;
    private static final Map<ResourceLocation, Long> UPGRADES = new HashMap<ResourceLocation, Long>();

    public static long getExtraEu(ItemLike item) {
        return UPGRADES.getOrDefault(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), 0L);
    }

    public static void registerUpgrade(ItemLike item, long extraEu) {
        UpgradeComponent.registerUpgrade(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), extraEu);
    }

    public static void registerUpgrade(ResourceLocation itemId, long extraEu) {
        Objects.requireNonNull(itemId);
        if (extraEu <= 0L) {
            throw new IllegalArgumentException("extraEu must be positive");
        }
        if (UPGRADES.containsKey(itemId)) {
            throw new IllegalArgumentException("Upgrade already registered:" + itemId);
        }
        UPGRADES.put(itemId, extraEu);
    }

    @Override
    public void writeNbt(CompoundTag tag) {
        tag.put("upgradesItemStack", (Tag)this.itemStack.save(new CompoundTag()));
    }

    @Override
    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        this.itemStack = ItemStack.of((CompoundTag)tag.getCompound("upgradesItemStack"));
    }

    public InteractionResult onUse(MachineBlockEntity be, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (UpgradeComponent.getExtraEu((ItemLike)stackInHand.getItem()) > 0L) {
            boolean changed = false;
            if (this.itemStack.isEmpty()) {
                this.itemStack = stackInHand.copy();
                if (!player.isCreative()) {
                    stackInHand.setCount(0);
                }
                changed = true;
            } else if (stackInHand.getItem() == this.itemStack.getItem()) {
                int maxAdded = Math.min(stackInHand.getCount(), this.itemStack.getMaxStackSize() - this.itemStack.getCount());
                changed = maxAdded > 0;
                this.itemStack.grow(maxAdded);
                if (!player.isCreative()) {
                    stackInHand.shrink(maxAdded);
                }
            }
            if (changed) {
                be.setChanged();
                if (!be.getLevel().isClientSide()) {
                    be.sync();
                }
                return InteractionResult.sidedSuccess((boolean)be.getLevel().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public long getAddMaxEUPerTick() {
        if (this.itemStack.isEmpty()) {
            return 0L;
        }
        return (long)this.itemStack.getCount() * UpgradeComponent.getExtraEu((ItemLike)this.itemStack.getItem());
    }

    @Override
    public ItemStack getDrop() {
        return this.itemStack;
    }

    public void setStackServer(MachineBlockEntity be, ItemStack stack) {
        this.itemStack = stack;
        be.setChanged();
        be.sync();
    }

    static {
        UpgradeComponent.registerUpgrade((ItemLike)MIItem.BASIC_UPGRADE.asItem(), 2L);
        UpgradeComponent.registerUpgrade((ItemLike)MIItem.ADVANCED_UPGRADE.asItem(), 8L);
        UpgradeComponent.registerUpgrade((ItemLike)MIItem.TURBO_UPGRADE.asItem(), 32L);
        UpgradeComponent.registerUpgrade((ItemLike)MIItem.HIGHLY_ADVANCED_UPGRADE.asItem(), 128L);
        UpgradeComponent.registerUpgrade((ItemLike)MIItem.QUANTUM_UPGRADE.asItem(), 999999999L);
        KubeJSProxy.instance.fireRegisterUpgradesEvent();
    }
}

