/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.TextHelper;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;

public class EnergyBarClient
implements GuiComponentClient {
    final EnergyBar.Parameters params;
    long eu;
    long maxEu;

    public EnergyBarClient(FriendlyByteBuf buf) {
        this.params = new EnergyBar.Parameters(buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(FriendlyByteBuf buf) {
        this.eu = buf.readLong();
        this.maxEu = buf.readLong();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public class Renderer
    implements ClientComponentRenderer {
        public static final int WIDTH = 13;
        public static final int HEIGHT = 18;

        public static void renderEnergy(GuiGraphics guiGraphics, int px, int py, float fill) {
            guiGraphics.blit(MachineScreen.SLOT_ATLAS, px, py, 230, 0, 13, 18);
            int fillPixels = (int)((double)(fill * 18.0f) * 0.9 + 1.8);
            if ((double)fill > 0.95) {
                fillPixels = 18;
            }
            guiGraphics.blit(MachineScreen.SLOT_ATLAS, px, py + 18 - fillPixels, 243, 18 - fillPixels, 13, fillPixels);
        }

        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            Renderer.renderEnergy(guiGraphics, x + EnergyBarClient.this.params.renderX, y + EnergyBarClient.this.params.renderY, (float)EnergyBarClient.this.eu / (float)EnergyBarClient.this.maxEu);
        }

        @Override
        public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle(EnergyBarClient.this.params.renderX, EnergyBarClient.this.params.renderY, 13, 18, cursorX - x, cursorY - y)) {
                MutableComponent tooltip;
                if (Screen.hasShiftDown()) {
                    tooltip = MIText.EuMaxed.text(EnergyBarClient.this.eu, EnergyBarClient.this.maxEu, "");
                } else {
                    TextHelper.MaxedAmount maxedAmount = TextHelper.getMaxedAmount(EnergyBarClient.this.eu, EnergyBarClient.this.maxEu);
                    tooltip = MIText.EuMaxed.text(maxedAmount.digit(), maxedAmount.maxDigit(), maxedAmount.unit());
                }
                guiGraphics.renderTooltip(font, Collections.singletonList(tooltip), Optional.empty(), cursorX, cursorY);
            }
        }
    }
}

