/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ShapeSelection {

    public static class Server
    implements GuiComponent.Server<int[]> {
        public final Behavior behavior;
        private final List<LineInfo> lines;

        public Server(Behavior behavior, LineInfo ... lines) {
            Preconditions.checkArgument((lines.length > 0 ? 1 : 0) != 0);
            this.behavior = behavior;
            this.lines = List.of(lines);
        }

        @Override
        public int[] copyData() {
            return IntStream.range(0, this.lines.size()).map(this.behavior::getCurrentIndex).toArray();
        }

        @Override
        public boolean needsSync(int[] cachedData) {
            for (int i = 0; i < this.lines.size(); ++i) {
                if (cachedData[i] == this.behavior.getCurrentIndex(i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void writeInitialData(FriendlyByteBuf buf) {
            buf.writeVarInt(this.lines.size());
            for (LineInfo line : this.lines) {
                buf.writeVarInt(line.numValues);
                for (Component component : line.translations) {
                    buf.writeComponent(component);
                }
                buf.writeBoolean(line.useArrows);
            }
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(FriendlyByteBuf buf) {
            for (int i = 0; i < this.lines.size(); ++i) {
                buf.writeVarInt(this.behavior.getCurrentIndex(i));
            }
        }

        @Override
        public ResourceLocation getId() {
            return GuiComponents.SHAPE_SELECTION;
        }
    }

    public record LineInfo(int numValues, List<? extends Component> translations, boolean useArrows) {
        public LineInfo {
            Preconditions.checkArgument((numValues == translations.size() ? 1 : 0) != 0);
        }
    }

    public static interface Behavior {
        public void handleClick(int var1, int var2);

        public int getCurrentIndex(int var1);
    }
}

