/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SlotPanel {
    public static int getSlotX(MachineGuiParameters guiParameters) {
        return guiParameters.backgroundWidth + 6;
    }

    public static int getSlotY(int slotIndex) {
        return 19 + slotIndex * 20;
    }

    public static enum SlotType {
        REDSTONE_MODULE(SlotGroup.REDSTONE_MODULE, 1, MIItem.REDSTONE_CONTROL_MODULE::is, 36, 80, MIText.AcceptsRedstoneControlModule),
        UPGRADES(SlotGroup.UPGRADES, 64, stack -> UpgradeComponent.getExtraEu((ItemLike)stack.getItem()) > 0L, 0, 80, MIText.AcceptsUpgrades),
        CASINGS(SlotGroup.CASING, 1, stack -> CasingComponent.getCasingTier(stack.getItem()) != null, 18, 80, MIText.AcceptsMachineHull);

        public final SlotGroup group;
        public final int slotLimit;
        public final Predicate<ItemStack> insertionChecker;
        public final int u;
        public final int v;
        public final MIText tooltip;

        private SlotType(SlotGroup group, int slotLimit, Predicate<ItemStack> insertionChecker, int u, int v, MIText tooltip) {
            this.group = group;
            this.slotLimit = slotLimit;
            this.insertionChecker = insertionChecker;
            this.u = u;
            this.v = v;
            this.tooltip = tooltip;
        }

        public boolean mayPlace(ItemStack stack) {
            return this.insertionChecker.test(stack);
        }
    }

    public static class Server
    implements GuiComponent.ServerNoData {
        private final MachineBlockEntity machine;
        private final List<Consumer<GuiComponent.MenuFacade>> slotFactories = new ArrayList<Consumer<GuiComponent.MenuFacade>>();
        private final List<SlotType> slotTypes = new ArrayList<SlotType>();

        public Server(MachineBlockEntity machine) {
            this.machine = machine;
        }

        public Server withRedstoneControl(RedstoneControlComponent redstoneControlComponent) {
            return this.addSlot(SlotType.REDSTONE_MODULE, () -> redstoneControlComponent.getDrop().copy(), redstoneControlComponent::setStackServer);
        }

        public Server withUpgrades(UpgradeComponent upgradeComponent) {
            return this.addSlot(SlotType.UPGRADES, () -> upgradeComponent.getDrop().copy(), upgradeComponent::setStackServer);
        }

        public Server withCasing(CasingComponent casingComponent) {
            return this.addSlot(SlotType.CASINGS, () -> casingComponent.getDrop().copy(), casingComponent::setCasingServer);
        }

        private Server addSlot(final SlotType type, final Supplier<ItemStack> getStack, final BiConsumer<MachineBlockEntity, ItemStack> setStack) {
            int slotIndex = this.slotTypes.size();
            this.slotFactories.add(facade -> facade.addSlotToMenu(new HackySlot(SlotPanel.getSlotX(this.machine.guiParams), SlotPanel.getSlotY(slotIndex)){

                @Override
                protected ItemStack getRealStack() {
                    return (ItemStack)getStack.get();
                }

                @Override
                protected void setRealStack(ItemStack stack) {
                    setStack.accept(machine, stack);
                }

                public boolean mayPlace(ItemStack stack) {
                    return type.mayPlace(stack);
                }

                public int getMaxStackSize() {
                    return type.slotLimit;
                }
            }, type.group));
            this.slotTypes.add(type);
            return this;
        }

        @Override
        public void writeInitialData(FriendlyByteBuf buf) {
            buf.writeVarInt(this.slotFactories.size());
            for (SlotType type : this.slotTypes) {
                buf.writeEnum((Enum)type);
            }
        }

        @Override
        public ResourceLocation getId() {
            return GuiComponents.SLOT_PANEL;
        }

        @Override
        public void setupMenu(GuiComponent.MenuFacade menu) {
            for (Consumer<GuiComponent.MenuFacade> factory : this.slotFactories) {
                factory.accept(menu);
            }
        }
    }
}

