/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.models;

import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.machines.models.MachineCasing;
import java.util.HashMap;
import java.util.Map;

public class MachineCasings {
    public static final Map<String, MachineCasing> registeredCasings = new HashMap<String, MachineCasing>();
    public static final MachineCasing BRICKED_BRONZE = MachineCasings.create("bricked_bronze");
    public static final MachineCasing BRICKED_STEEL = MachineCasings.create("bricked_steel");
    public static final MachineCasing BRICKS = MachineCasings.create("bricks");
    public static final MachineCasing BRONZE = MachineCasings.create("bronze");
    public static final MachineCasing BRONZE_PLATED_BRICKS = MachineCasings.create("bronze_plated_bricks");
    public static final MachineCasing CLEAN_STAINLESS_STEEL = MachineCasings.create("clean_stainless_steel_machine_casing");
    public static final MachineCasing CONFIGURABLE_TANK = MachineCasings.create("configurable_tank");
    public static final MachineCasing STAINLESS_STEEL_PIPE = MachineCasings.create("stainless_steel_machine_casing_pipe");
    public static final MachineCasing FIREBRICKS = MachineCasings.create("firebricks");
    public static final MachineCasing FROSTPROOF = MachineCasings.create("frostproof_machine_casing");
    public static final MachineCasing HEATPROOF = MachineCasings.create("heatproof_machine_casing");
    public static final MachineCasing STEEL = MachineCasings.create("steel");
    public static final MachineCasing STEEL_CRATE = MachineCasings.create("steel_crate");
    public static final MachineCasing TITANIUM = MachineCasings.create("titanium");
    public static final MachineCasing TITANIUM_PIPE = MachineCasings.create("titanium_machine_casing_pipe");
    public static final MachineCasing SOLID_TITANIUM = MachineCasings.create("solid_titanium_machine_casing");
    public static final MachineCasing NUCLEAR = MachineCasings.create("nuclear_casing");
    public static final MachineCasing PLASMA_HANDLING_IRIDIUM = MachineCasings.create("plasma_handling_iridium_machine_casing");

    public static MachineCasing create(String name) {
        if (registeredCasings.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate machine casing definition: " + name);
        }
        MachineCasing casing = new MachineCasing(name);
        registeredCasings.put(name, casing);
        return casing;
    }

    public static MachineCasing get(String name) {
        MachineCasing casing = registeredCasings.get(name);
        if (casing != null) {
            return casing;
        }
        throw new IllegalArgumentException("Machine casing model \"" + name + "\" does not exist.");
    }

    static {
        KubeJSProxy.instance.fireRegisterMachineCasingsEvent();
    }
}

