/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBER;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.thirdparty.fabricrendering.QuadBuffer;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.client.fluid.FluidVariantRendering;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;

public class MultiblockTankBER
extends MultiblockMachineBER {
    public MultiblockTankBER(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void render(MultiblockMachineBlockEntity be, float tickDelta, PoseStack ms, MultiBufferSource vcp, int light, int overlay) {
        super.render(be, tickDelta, ms, vcp, light, overlay);
        LargeTankMultiblockBlockEntity tankBlockEntity = (LargeTankMultiblockBlockEntity)be;
        FluidVariant fluid = tankBlockEntity.getFluid();
        if (tankBlockEntity.shapeValid.shapeValid && !fluid.isBlank() && tankBlockEntity.getFullnessFraction() > 0.0) {
            float fullness;
            VertexConsumer vc = vcp.getBuffer(Sheets.translucentCullBlockSheet());
            TextureAtlasSprite sprite = FluidVariantRendering.getSprite(fluid);
            int[] cornerPosition = tankBlockEntity.getCornerPosition();
            int maxX = cornerPosition[0];
            int totalMaxY = cornerPosition[1];
            int maxZ = cornerPosition[2];
            int minX = cornerPosition[3];
            int totalMinY = cornerPosition[4];
            int minZ = cornerPosition[5];
            float topHeight = fullness = (float)tankBlockEntity.getFullnessFraction();
            float bottomHeight = 0.0f;
            if (fluid.getFluid().getFluidType().isLighterThanAir()) {
                topHeight = 1.0f;
                bottomHeight = 1.0f - fullness;
            }
            int minY = (int)Math.floor(bottomHeight * (float)(totalMaxY + 1 - totalMinY) + (float)totalMinY);
            int maxY = (int)Math.floor(topHeight * (float)(totalMaxY + 1 - totalMinY) + (float)totalMinY);
            int[] mins = new int[]{minX, minY, minZ};
            int[] maxs = new int[]{maxX, maxY, maxZ};
            Vec3i[] dirs = new Vec3i[]{Direction.EAST.getNormal(), Direction.UP.getNormal(), Direction.SOUTH.getNormal()};
            QuadBuffer emitter = new QuadBuffer();
            for (Direction direction : Direction.values()) {
                emitter.clear();
                ms.pushPose();
                int u_index = direction.getAxis() == Direction.Axis.X ? 2 : 0;
                int v_index = direction.getAxis() == Direction.Axis.Y ? 2 : 1;
                Vec3i offset_u = dirs[u_index];
                Vec3i offset_v = dirs[v_index];
                int dirAxis = direction.getAxis() == Direction.Axis.X ? 0 : (direction.getAxis() == Direction.Axis.Z ? 2 : 1);
                int dirWays = direction.get3DDataValue() % 2;
                int offset_w = dirWays == 0 ? mins[dirAxis] : maxs[dirAxis];
                Vec3i origin = offset_u.multiply(mins[u_index]).offset(offset_v.multiply(mins[v_index])).offset(dirs[dirAxis].multiply(offset_w));
                float originX = origin.getX();
                float originY = origin.getY();
                float originZ = origin.getZ();
                if (direction == Direction.UP) {
                    originY = topHeight * (float)(totalMaxY + 1 - totalMinY) - 1.0f;
                } else if (direction == Direction.DOWN) {
                    originY = bottomHeight * (float)(totalMaxY + 1 - totalMinY);
                }
                ms.translate(originX, originY, originZ);
                int max_u = maxs[u_index] - mins[u_index];
                int max_v = maxs[v_index] - mins[v_index];
                for (int u = 0; u <= max_u; ++u) {
                    ms.pushPose();
                    for (int v = 0; v <= max_v; ++v) {
                        float bottom = 0.0f;
                        float top = 1.0f;
                        if (!direction.getAxis().isVertical()) {
                            if (v == 0) {
                                bottom = bottomHeight * (float)(totalMaxY + 1 - totalMinY) % 1.0f;
                            }
                            if (v == max_v) {
                                top = topHeight * (float)(totalMaxY + 1 - totalMinY) % 1.0f;
                            }
                        }
                        emitter.square(direction, 0.0f, bottom, 1.0f, top, 0.0f);
                        emitter.spriteBake(sprite, 4);
                        emitter.color(-1, -1, -1, -1);
                        int color = FluidVariantRendering.getColor(fluid, (BlockAndTintGetter)be.getLevel(), BlockPos.containing((double)((float)be.getBlockPos().getX() + originX + (float)(offset_u.getX() * u) + (float)(offset_v.getX() * v)), (double)((float)be.getBlockPos().getY() + originY + (float)(offset_u.getY() * u) + (float)(offset_v.getY() * v)), (double)((float)be.getBlockPos().getZ() + originZ + (float)(offset_u.getZ() * u) + (float)(offset_v.getZ() * v))));
                        float r = (float)(color >> 16 & 0xFF) / 256.0f;
                        float g = (float)(color >> 8 & 0xFF) / 256.0f;
                        float b = (float)(color & 0xFF) / 256.0f;
                        vc.putBulkData(ms.last(), emitter.toBakedQuad(sprite), r, g, b, 0xF000F0, OverlayTexture.NO_OVERLAY);
                        ms.translate((float)offset_v.getX(), (float)offset_v.getY(), (float)offset_v.getZ());
                    }
                    ms.popPose();
                    ms.translate((float)offset_u.getX(), (float)offset_u.getY(), (float)offset_u.getZ());
                }
                ms.popPose();
            }
        }
    }
}

