/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks.world;

import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListener;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkPosMultiMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.jetbrains.annotations.Nullable;

public class ChunkEventListeners {
    public static ChunkPosMultiMap<ChunkEventListener> listeners = new ChunkPosMultiMap();

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ServerStoppedEvent.class, event -> ChunkEventListeners.serverStopCleanup());
        NeoForge.EVENT_BUS.addListener(ChunkEvent.Load.class, event -> {
            if (event.getLevel().isClientSide()) {
                return;
            }
            ChunkEventListeners.ensureServerThread(event.getLevel().getServer());
            Set<ChunkEventListener> cels = listeners.get(event.getLevel(), event.getChunk().getPos());
            if (cels != null) {
                for (ChunkEventListener cel : cels) {
                    cel.onLoad();
                }
            }
        });
        NeoForge.EVENT_BUS.addListener(ChunkEvent.Unload.class, event -> {
            if (event.getLevel().isClientSide()) {
                return;
            }
            ChunkEventListeners.ensureServerThread(event.getLevel().getServer());
            Set<ChunkEventListener> cels = listeners.get(event.getLevel(), event.getChunk().getPos());
            if (cels != null) {
                for (ChunkEventListener cel : cels) {
                    cel.onUnload();
                }
            }
        });
        NeoForge.EVENT_BUS.addListener(BlockEvent.NeighborNotifyEvent.class, event -> {
            LevelAccessor patt3075$temp = event.getLevel();
            if (patt3075$temp instanceof Level) {
                Level level = (Level)patt3075$temp;
                ChunkEventListeners.onBlockStateChange(level, new ChunkPos(event.getPos()), event.getPos());
            }
        });
    }

    public static void onBlockStateChange(Level world, ChunkPos chunkPos, BlockPos pos) {
        Set<ChunkEventListener> cels;
        ServerLevel serverLevel;
        if (world instanceof ServerLevel && (serverLevel = (ServerLevel)world).getServer().isSameThread() && (cels = listeners.get((LevelAccessor)world, chunkPos)) != null) {
            for (ChunkEventListener cel : cels) {
                cel.onBlockUpdate(pos);
            }
        }
    }

    private static void ensureServerThread(@Nullable MinecraftServer server) {
        if (server == null) {
            throw new RuntimeException("Null server!");
        }
        if (!server.isSameThread()) {
            throw new RuntimeException("Thread is not server thread!");
        }
    }

    private static void serverStopCleanup() {
        if (listeners.size() != 0) {
            listeners = new ChunkPosMultiMap();
        }
    }
}

