/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks.world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class ChunkPosMultiMap<T> {
    private final Map<LevelAccessor, HashMap<ChunkPos, Set<T>>> storage = new HashMap<LevelAccessor, HashMap<ChunkPos, Set<T>>>();

    public final void add(LevelAccessor world, ChunkPos chunkPos, T t) {
        this.storage.computeIfAbsent(world, w -> new HashMap()).computeIfAbsent(chunkPos, p -> new HashSet()).add(t);
    }

    public final void remove(LevelAccessor world, ChunkPos chunkPos, T t) {
        Map chunkPosMap = this.storage.get(world);
        Set tSet = (Set)chunkPosMap.get(chunkPos);
        if (!tSet.remove(t)) {
            throw new RuntimeException("Could not remove element at position " + chunkPos + " as it does not exist.");
        }
        if (tSet.size() == 0) {
            chunkPosMap.remove(chunkPos);
            if (chunkPosMap.size() == 0) {
                this.storage.remove(world);
            }
        }
    }

    @Nullable
    public final Set<T> get(LevelAccessor world, ChunkPos chunkPos) {
        Map chunkPosSetMap = this.storage.get(world);
        if (chunkPosSetMap == null) {
            return null;
        }
        return (Set)chunkPosSetMap.get(chunkPos);
    }

    public final int size() {
        return this.storage.size();
    }
}

