/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.util.DefaultedListWrapper;
import aztech.modern_industrialization.util.MIExtraCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class MachineRecipe
implements Recipe<Container> {
    final MachineRecipeType type;
    public int eu;
    public int duration;
    public List<ItemInput> itemInputs = new ArrayList<ItemInput>();
    public List<FluidInput> fluidInputs = new ArrayList<FluidInput>();
    public List<ItemOutput> itemOutputs = new ArrayList<ItemOutput>();
    public List<FluidOutput> fluidOutputs = new ArrayList<FluidOutput>();
    public List<MachineProcessCondition> conditions = new ArrayList<MachineProcessCondition>();

    public static MapCodec<MachineRecipe> codec(MachineRecipeType type) {
        return RecordCodecBuilder.mapCodec(g -> g.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("eu").forGetter(recipe -> recipe.eu), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(recipe -> recipe.duration), (App)MIExtraCodecs.maybeList(ItemInput.CODEC, "item_inputs").forGetter(recipe -> recipe.itemInputs), (App)MIExtraCodecs.maybeList(FluidInput.CODEC, "fluid_inputs").forGetter(recipe -> recipe.fluidInputs), (App)MIExtraCodecs.maybeList(ItemOutput.CODEC, "item_outputs").forGetter(recipe -> recipe.itemOutputs), (App)MIExtraCodecs.maybeList(FluidOutput.CODEC, "fluid_outputs").forGetter(recipe -> recipe.fluidOutputs), (App)MIExtraCodecs.maybeList(MachineProcessCondition.CODEC, "conditions").forGetter(recipe -> recipe.conditions)).apply((Applicative)g, (eu, duration, itemInputs, fluidInputs, itemOutputs, fluidOutputs, conditions) -> {
            MachineRecipe ret = new MachineRecipe(type);
            ret.eu = eu;
            ret.duration = duration;
            ret.itemInputs = itemInputs;
            ret.fluidInputs = fluidInputs;
            ret.itemOutputs = itemOutputs;
            ret.fluidOutputs = fluidOutputs;
            ret.conditions = conditions;
            return ret;
        }));
    }

    MachineRecipe(MachineRecipeType type) {
        this.type = type;
    }

    public long getTotalEu() {
        return (long)this.eu * (long)this.duration;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(Container inv, Level world) {
        throw new UnsupportedOperationException();
    }

    public ItemStack assemble(Container inv, RegistryAccess registryAccess) {
        throw new UnsupportedOperationException();
    }

    public boolean canCraftInDimensions(int width, int height) {
        throw new UnsupportedOperationException();
    }

    public NonNullList<Ingredient> getIngredients() {
        return new DefaultedListWrapper<Ingredient>(this.itemInputs.stream().filter(i -> i.probability == 1.0f).map(i -> {
            for (ItemStack stack : i.ingredient.getItems()) {
                stack.setCount(i.amount);
            }
            return i.ingredient;
        }).collect(Collectors.toList()));
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        for (ItemOutput o : this.itemOutputs) {
            if (o.probability != 1.0f) continue;
            return new ItemStack((ItemLike)o.item, o.amount);
        }
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return this.type;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    public boolean conditionsMatch(MachineProcessCondition.Context context) {
        for (MachineProcessCondition condition : this.conditions) {
            if (condition.canProcessRecipe(context, this)) continue;
            return false;
        }
        return true;
    }

    public static class ItemOutput {
        public static final Codec<ItemOutput> CODEC = RecordCodecBuilder.create(g -> g.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(itemOutput -> itemOutput.item), (App)MIExtraCodecs.optionalFieldAlwaysWrite(ExtraCodecs.POSITIVE_INT, "amount", 1).forGetter(itemOutput -> itemOutput.amount), (App)ExtraCodecs.strictOptionalField(MIExtraCodecs.FLOAT_01, (String)"probability", (Object)Float.valueOf(1.0f)).forGetter(itemOutput -> Float.valueOf(itemOutput.probability))).apply((Applicative)g, ItemOutput::new));
        public final Item item;
        public final int amount;
        public final float probability;

        public ItemOutput(Item item, int amount, float probability) {
            this.item = item;
            this.amount = amount;
            this.probability = probability;
        }

        public ItemStack getStack() {
            return new ItemStack((ItemLike)this.item, this.amount);
        }
    }

    public static class ItemInput {
        private static final MapCodec<Ingredient> INGREDIENT_CODEC = MIExtraCodecs.xor(MIExtraCodecs.xor(ItemStack.SINGLE_ITEM_CODEC.fieldOf("item"), TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag")), Ingredient.CODEC_NONEMPTY.fieldOf("ingredient")).xmap(des -> (Ingredient)des.map(x -> (Ingredient)x.map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0}), tagKey -> ItemInput.ingredientFromTagKey((TagKey<Item>)tagKey)), x -> x), ing -> {
            if (ing.values.length == 1) {
                Ingredient.Value patt7440$temp = ing.values[0];
                if (patt7440$temp instanceof Ingredient.ItemValue) {
                    Ingredient.ItemValue itemValue = (Ingredient.ItemValue)patt7440$temp;
                    return Either.left((Object)Either.left((Object)itemValue.item()));
                }
                Ingredient.Value patt7629$temp = ing.values[0];
                if (patt7629$temp instanceof Ingredient.TagValue) {
                    Ingredient.TagValue tagValue = (Ingredient.TagValue)patt7629$temp;
                    return Either.left((Object)Either.right((Object)tagValue.tag()));
                }
            }
            return Either.right((Object)ing);
        });
        private static final MapCodec<Integer> AMOUNT_CODEC = NeoForgeExtraCodecs.mapWithAlternative((MapCodec)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)"amount"), (MapCodec)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)"count")).xmap(deserialized -> deserialized.orElse(1), Optional::of);
        public static final Codec<ItemInput> CODEC = RecordCodecBuilder.create(g -> g.group((App)INGREDIENT_CODEC.forGetter(itemInput -> itemInput.ingredient), (App)AMOUNT_CODEC.forGetter(itemInput -> itemInput.amount), (App)ExtraCodecs.strictOptionalField(MIExtraCodecs.FLOAT_01, (String)"probability", (Object)Float.valueOf(1.0f)).forGetter(itemInput -> Float.valueOf(itemInput.probability))).apply((Applicative)g, ItemInput::new));
        public final Ingredient ingredient;
        public final int amount;
        public final float probability;

        private static Ingredient ingredientFromTagKey(TagKey<Item> tagKey) {
            return new Ingredient(Stream.of(new Ingredient.TagValue(tagKey))){};
        }

        public ItemInput(Ingredient ingredient, int amount, float probability) {
            this.ingredient = ingredient;
            this.amount = amount;
            this.probability = probability;
        }

        public boolean matches(ItemStack otherStack) {
            return this.ingredient.test(otherStack);
        }

        public List<Item> getInputItems() {
            return Arrays.stream(this.ingredient.getItems()).map(ItemStack::getItem).distinct().collect(Collectors.toList());
        }
    }

    public static class FluidInput {
        public static final Codec<FluidInput> CODEC = RecordCodecBuilder.create(g -> g.group((App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(fluidInput -> fluidInput.fluid), (App)MIExtraCodecs.optionalFieldAlwaysWrite(MIExtraCodecs.POSITIVE_LONG, "amount", 1L).forGetter(fluidInput -> fluidInput.amount), (App)ExtraCodecs.strictOptionalField(MIExtraCodecs.FLOAT_01, (String)"probability", (Object)Float.valueOf(1.0f)).forGetter(fluidInput -> Float.valueOf(fluidInput.probability))).apply((Applicative)g, FluidInput::new));
        public final Fluid fluid;
        public final long amount;
        public final float probability;

        public FluidInput(Fluid fluid, long amount, float probability) {
            this.fluid = fluid;
            this.amount = amount;
            this.probability = probability;
        }
    }

    public static class FluidOutput {
        public static final Codec<FluidOutput> CODEC = RecordCodecBuilder.create(g -> g.group((App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(fluidOutput -> fluidOutput.fluid), (App)MIExtraCodecs.optionalFieldAlwaysWrite(MIExtraCodecs.POSITIVE_LONG, "amount", 1L).forGetter(fluidOutput -> fluidOutput.amount), (App)ExtraCodecs.strictOptionalField(MIExtraCodecs.FLOAT_01, (String)"probability", (Object)Float.valueOf(1.0f)).forGetter(fluidOutput -> Float.valueOf(fluidOutput.probability))).apply((Applicative)g, FluidOutput::new));
        public final Fluid fluid;
        public final long amount;
        public final float probability;

        public FluidOutput(Fluid fluid, long amount, float probability) {
            this.fluid = fluid;
            this.amount = amount;
            this.probability = probability;
        }
    }
}

