/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class MachineRecipeType
implements RecipeType<MachineRecipe>,
RecipeSerializer<MachineRecipe> {
    private final Codec<MachineRecipe> codec;
    private final Map<Item, List<RecipeHolder<MachineRecipe>>> recipeCache = new HashMap<Item, List<RecipeHolder<MachineRecipe>>>();
    private final List<RecipeHolder<MachineRecipe>> fluidOnlyRecipes = new ArrayList<RecipeHolder<MachineRecipe>>();
    private long lastUpdate = 0L;
    private static final long UPDATE_INTERVAL = 20000L;
    private final ResourceLocation id;
    private boolean allowItemInput = false;
    private boolean allowFluidInput = false;
    private boolean allowItemOutput = false;
    private boolean allowFluidOutput = false;

    public MachineRecipeType(ResourceLocation id) {
        this.id = id;
        MapCodec<MachineRecipe> baseCodec = MachineRecipe.codec(this);
        this.codec = MapCodec.of(baseCodec, (MapDecoder)baseCodec.flatMap(machineRecipe -> {
            try {
                this.validateRecipe((MachineRecipe)machineRecipe);
                return DataResult.success((Object)machineRecipe);
            }
            catch (IllegalArgumentException e) {
                return DataResult.error(() -> "Failed to read machine recipe:" + e.getMessage());
            }
        }), () -> "MachineRecipe[" + baseCodec + "]").codec();
    }

    protected Collection<RecipeHolder<MachineRecipe>> getManagerRecipes(Level world) {
        return world.getRecipeManager().getAllRecipesFor((RecipeType)this);
    }

    public Collection<RecipeHolder<MachineRecipe>> getRecipes(Level world) {
        return this.getManagerRecipes(world);
    }

    @Nullable
    public RecipeHolder<MachineRecipe> getRecipe(Level world, ResourceLocation id) {
        return this.getRecipes(world).stream().filter(r -> r.id().equals((Object)id)).findFirst().orElse(null);
    }

    private void updateRecipeCache(ServerLevel world) {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate <= 20000L) {
            return;
        }
        this.lastUpdate = time;
        this.recipeCache.clear();
        this.fluidOnlyRecipes.clear();
        for (RecipeHolder<MachineRecipe> recipe : this.getRecipes((Level)world)) {
            if (((MachineRecipe)recipe.value()).itemInputs.size() == 0) {
                if (((MachineRecipe)recipe.value()).fluidInputs.size() <= 0) continue;
                this.fluidOnlyRecipes.add(recipe);
                continue;
            }
            for (Item inputItem : ((MachineRecipe)recipe.value()).itemInputs.get(0).getInputItems()) {
                this.recipeCache.putIfAbsent(inputItem, new ArrayList());
                this.recipeCache.get(inputItem).add(recipe);
            }
        }
    }

    public Collection<RecipeHolder<MachineRecipe>> getMatchingRecipes(ServerLevel world, Item input) {
        this.updateRecipeCache(world);
        return Collections.unmodifiableCollection(this.recipeCache.getOrDefault(input, Collections.emptyList()));
    }

    public Collection<RecipeHolder<MachineRecipe>> getFluidOnlyRecipes(ServerLevel world) {
        this.updateRecipeCache(world);
        return Collections.unmodifiableList(this.fluidOnlyRecipes);
    }

    public MachineRecipeType withItemInputs() {
        this.allowItemInput = true;
        return this;
    }

    public MachineRecipeType withFluidInputs() {
        this.allowFluidInput = true;
        return this;
    }

    public MachineRecipeType withItemOutputs() {
        this.allowItemOutput = true;
        return this;
    }

    public MachineRecipeType withFluidOutputs() {
        this.allowFluidOutput = true;
        return this;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getPath() {
        return this.id.getPath();
    }

    private void validateRecipe(MachineRecipe recipe) {
        if (!this.allowItemInput && recipe.itemInputs.size() > 0) {
            throw new IllegalArgumentException("Item inputs are not allowed.");
        }
        if (!this.allowFluidInput && recipe.fluidInputs.size() > 0) {
            throw new IllegalArgumentException("Fluid inputs are not allowed.");
        }
        if (!this.allowItemOutput && recipe.itemOutputs.size() > 0) {
            throw new IllegalArgumentException("Item outputs are not allowed.");
        }
        if (!this.allowFluidOutput && recipe.fluidOutputs.size() > 0) {
            throw new IllegalArgumentException("Fluid outputs are not allowed.");
        }
        if (recipe.itemInputs.size() + recipe.fluidInputs.size() == 0) {
            throw new IllegalArgumentException("Must have at least one fluid or item input.");
        }
        if (recipe.itemOutputs.size() + recipe.fluidOutputs.size() == 0) {
            throw new IllegalArgumentException("Must have at least one fluid or item output.");
        }
    }

    public Codec<MachineRecipe> codec() {
        return this.codec;
    }

    private static <T> List<T> readArray(JsonObject json, String element, Function<JsonObject, T> reader) {
        if (!GsonHelper.isArrayNode((JsonObject)json, (String)element)) {
            JsonElement backupObject = json.get(element);
            if (backupObject != null && backupObject.isJsonObject()) {
                return Arrays.asList(reader.apply(backupObject.getAsJsonObject()));
            }
            return Collections.emptyList();
        }
        JsonArray array = GsonHelper.getAsJsonArray((JsonObject)json, (String)element);
        JsonObject[] objects = new JsonObject[array.size()];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = array.get(i).getAsJsonObject();
        }
        return Arrays.stream(objects).map(reader).collect(Collectors.toList());
    }

    private static <T> List<T> readList(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> reader) {
        ArrayList<T> l = new ArrayList<T>();
        int size = buf.readVarInt();
        for (int i = 0; i < size; ++i) {
            l.add(reader.apply(buf));
        }
        return l;
    }

    private static <T> void writeList(FriendlyByteBuf buf, List<T> list, BiConsumer<FriendlyByteBuf, T> writer) {
        buf.writeVarInt(list.size());
        for (T t : list) {
            writer.accept(buf, (FriendlyByteBuf)t);
        }
    }

    public MachineRecipe fromNetwork(FriendlyByteBuf buf) {
        MachineRecipe recipe = new MachineRecipe(this);
        recipe.eu = buf.readVarInt();
        recipe.duration = buf.readVarInt();
        recipe.itemInputs = MachineRecipeType.readList(buf, b -> new MachineRecipe.ItemInput(Ingredient.fromNetwork((FriendlyByteBuf)b), b.readVarInt(), b.readFloat()));
        recipe.fluidInputs = MachineRecipeType.readList(buf, b -> new MachineRecipe.FluidInput((Fluid)BuiltInRegistries.FLUID.byId(b.readVarInt()), b.readVarLong(), b.readFloat()));
        recipe.itemOutputs = MachineRecipeType.readList(buf, b -> new MachineRecipe.ItemOutput(Item.byId((int)b.readVarInt()), b.readVarInt(), b.readFloat()));
        recipe.fluidOutputs = MachineRecipeType.readList(buf, b -> new MachineRecipe.FluidOutput((Fluid)BuiltInRegistries.FLUID.byId(b.readVarInt()), b.readVarLong(), b.readFloat()));
        recipe.conditions = MachineRecipeType.readList(buf, b -> (MachineProcessCondition)b.readJsonWithCodec(MachineProcessCondition.CODEC));
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf buf, MachineRecipe recipe) {
        buf.writeVarInt(recipe.eu);
        buf.writeVarInt(recipe.duration);
        MachineRecipeType.writeList(buf, recipe.itemInputs, (b, i) -> {
            i.ingredient.toNetwork(buf);
            buf.writeVarInt(i.amount);
            buf.writeFloat(i.probability);
        });
        MachineRecipeType.writeList(buf, recipe.fluidInputs, (b, i) -> {
            buf.writeVarInt(BuiltInRegistries.FLUID.getId((Object)i.fluid));
            buf.writeVarLong(i.amount);
            buf.writeFloat(i.probability);
        });
        MachineRecipeType.writeList(buf, recipe.itemOutputs, (b, i) -> {
            buf.writeVarInt(Item.getId((Item)i.item));
            buf.writeVarInt(i.amount);
            buf.writeFloat(i.probability);
        });
        MachineRecipeType.writeList(buf, recipe.fluidOutputs, (b, i) -> {
            buf.writeVarInt(BuiltInRegistries.FLUID.getId((Object)i.fluid));
            buf.writeVarLong(i.amount);
            buf.writeFloat(i.probability);
        });
        MachineRecipeType.writeList(buf, recipe.conditions, (b, cond) -> buf.writeJsonWithCodec(MachineProcessCondition.CODEC, cond));
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }
}

