/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public record BiomeProcessCondition(ResourceKey<Biome> biome) implements MachineProcessCondition
{
    static final Codec<BiomeProcessCondition> CODEC = ResourceKey.codec((ResourceKey)Registries.BIOME).xmap(BiomeProcessCondition::new, BiomeProcessCondition::biome);

    @Override
    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        Holder entityBiome = context.getLevel().getBiome(context.getBlockEntity().getBlockPos());
        return entityBiome.is(this.biome);
    }

    @Override
    public void appendDescription(List<Component> list) {
        ResourceLocation loc = this.biome.location();
        MutableComponent biomeComponent = Component.translatable((String)"biome.%s.%s".formatted(loc.getNamespace(), loc.getPath()));
        list.add((Component)MIText.RequiresBiome.text(biomeComponent));
    }

    @Override
    public Codec<? extends MachineProcessCondition> codec(boolean syncToClient) {
        return CODEC;
    }
}

