/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessConditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public interface MachineProcessCondition {
    public static final Codec<MachineProcessCondition> CODEC = MachineProcessCondition.makeCodec(false);
    public static final Codec<MachineProcessCondition> CODEC_FOR_SYNC = MachineProcessCondition.makeCodec(true);

    private static Codec<MachineProcessCondition> makeCodec(boolean syncToClient) {
        return ResourceLocation.CODEC.flatXmap(resLoc -> Optional.ofNullable(MachineProcessConditions.get(resLoc)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown machine process condition " + resLoc)), codec -> Optional.ofNullable(MachineProcessConditions.getId((Codec<? extends MachineProcessCondition>)codec)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown machine process condition codec " + codec))).dispatch(cond -> cond.codec(syncToClient), c -> c);
    }

    public boolean canProcessRecipe(Context var1, MachineRecipe var2);

    public void appendDescription(List<Component> var1);

    public Codec<? extends MachineProcessCondition> codec(boolean var1);

    public static interface Context {
        public MachineBlockEntity getBlockEntity();

        default public ServerLevel getLevel() {
            return (ServerLevel)this.getBlockEntity().getLevel();
        }
    }
}

