/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.machines.recipe.condition.AdjacentBlockProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.BiomeProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.CustomProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.DimensionProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class MachineProcessConditions {
    private static final BiMap<ResourceLocation, Codec<? extends MachineProcessCondition>> MAP = HashBiMap.create();

    public static void register(ResourceLocation id, Codec<? extends MachineProcessCondition> serializer) {
        if (MAP.get((Object)id) != null || MAP.inverse().get(serializer) != null) {
            throw new IllegalArgumentException("Duplicate registration for process condition " + id);
        }
        MAP.put((Object)id, serializer);
    }

    @Nullable
    public static Codec<? extends MachineProcessCondition> get(ResourceLocation id) {
        return (Codec)MAP.get((Object)id);
    }

    public static ResourceLocation getId(Codec<? extends MachineProcessCondition> serializer) {
        return (ResourceLocation)MAP.inverse().get(serializer);
    }

    static {
        MachineProcessConditions.register(new MIIdentifier("dimension"), DimensionProcessCondition.CODEC);
        MachineProcessConditions.register(new MIIdentifier("adjacent_block"), AdjacentBlockProcessCondition.CODEC);
        MachineProcessConditions.register(new MIIdentifier("biome"), BiomeProcessCondition.CODEC);
        MachineProcessConditions.register(new MIIdentifier("custom"), CustomProcessCondition.CODEC);
    }
}

