/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKey;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PartItemPathFormatter {
    public static String idFromPath(String path) {
        return "modern_industrialization:" + path;
    }

    public String getPartItemPath(String var1, PartKey var2);

    public String getPartItemTag(String var1, PartKey var2);

    default public String getPartItemId(String materialName, PartKey partKey) {
        return "modern_industrialization:" + this.getPartItemPath(materialName, partKey);
    }

    public record Overridden(String path, String tag) implements PartItemPathFormatter
    {
        @Override
        public String getPartItemPath(String materialName, PartKey partKey) {
            if (this.path.contains("%s")) {
                return String.format(this.path, materialName);
            }
            return this.path;
        }

        @Override
        public String getPartItemTag(String materialName, PartKey partKey) {
            if (MIParts.TAGGED_PARTS.contains(partKey)) {
                if (this.tag.contains("%s")) {
                    return "#forge:" + String.format(this.tag, materialName);
                }
                return this.tag;
            }
            return PartItemPathFormatter.idFromPath(this.getPartItemPath(materialName, partKey));
        }
    }

    public record Default() implements PartItemPathFormatter
    {
        @Override
        public String getPartItemPath(String materialName, PartKey partKey) {
            return materialName + "_" + partKey.key;
        }

        @Override
        public String getPartItemTag(String materialName, PartKey partKey) {
            if (MIParts.TAGGED_PARTS.contains(partKey)) {
                return "#forge:%ss/%s".formatted(partKey.key, materialName);
            }
            return PartItemPathFormatter.idFromPath(this.getPartItemPath(materialName, partKey));
        }
    }
}

