/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe.builder;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MIRecipeJson;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.recipe.builder.MIRecipeBuilder;
import aztech.modern_industrialization.materials.recipe.builder.MaterialRecipeBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class ShapedRecipeBuilder
implements MaterialRecipeBuilder {
    public final String recipeId;
    private final MaterialBuilder.RecipeContext context;
    private boolean canceled = false;
    private final String id;
    private final ItemStack result;
    private final String[] pattern;
    private final Map<Character, Ingredient> inputs = new HashMap<Character, Ingredient>();

    public ShapedRecipeBuilder(MaterialBuilder.RecipeContext context, PartKeyProvider result, int count, String id, String ... pattern) {
        this.recipeId = "craft/" + id;
        this.context = context;
        this.id = id;
        MaterialItemPart output = context.getPart(result);
        if (output == null) {
            this.result = null;
            this.pattern = null;
            this.canceled = true;
        } else {
            this.result = new ItemStack((ItemLike)output.asItem(), count);
            this.pattern = pattern;
        }
        context.addRecipe(this);
    }

    public ShapedRecipeBuilder addPart(char key, PartKeyProvider part) {
        if (this.context.getPart(part) != null) {
            this.addInput(key, this.context.getPart(part).getItemId());
        } else {
            this.canceled = true;
        }
        return this;
    }

    public ShapedRecipeBuilder addTaggedPart(char key, PartKeyProvider part) {
        if (this.context.getPart(part) != null) {
            this.addInput(key, this.context.getPart(part).getTaggedItemId());
        } else {
            this.canceled = true;
        }
        return this;
    }

    public ShapedRecipeBuilder addInput(char key, TagKey<Item> tag) {
        return this.addInput(key, "#" + tag.location().toString());
    }

    public ShapedRecipeBuilder addInput(char key, String maybeTag) {
        if (!this.canceled) {
            if (this.inputs.containsKey(Character.valueOf(key))) {
                throw new IllegalArgumentException("Key mapping is already registered: " + key);
            }
            Ingredient ingredient = maybeTag.startsWith("#") ? Ingredient.of((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation(maybeTag.substring(1)))) : Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(maybeTag))});
            this.inputs.put(Character.valueOf(key), ingredient);
        }
        return this;
    }

    public ShapedRecipeBuilder addInput(char key, ItemLike item) {
        return this.addInput(key, BuiltInRegistries.ITEM.getKey((Object)item.asItem()).toString());
    }

    public ShapedRecipeBuilder exportToAssembler(int eu, int duration) {
        return this.exportToMachine(MIMachineRecipeTypes.ASSEMBLER, eu, duration, 1);
    }

    public ShapedRecipeBuilder exportToAssembler() {
        return this.exportToAssembler(8, 200);
    }

    public ShapedRecipeBuilder exportToMachine(MachineRecipeType machine, int eu, int duration, int division) {
        if (!this.canceled) {
            new MIRecipeBuilder(this.context, this.id, MIRecipeJson.fromShaped(machine, eu, duration, division, this.result, this.pattern, this.inputs));
        }
        return this;
    }

    public ShapedRecipeBuilder exportToMachine(MachineRecipeType machine) {
        return this.exportToMachine(machine, 2, (int)(200.0 * this.context.get(MaterialProperty.HARDNESS).timeFactor), 1);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void save(RecipeOutput recipeOutput) {
        if (!this.canceled) {
            String fullId = "materials/" + this.context.getMaterialName() + "/" + this.recipeId;
            recipeOutput.accept(MI.id(fullId), (Recipe)new ShapedRecipe("", CraftingBookCategory.MISC, ShapedRecipePattern.of(this.inputs, (String[])this.pattern), this.result), null);
        }
    }
}

