/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.misc.guidebook;

import aztech.modern_industrialization.util.MISavedData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class GuidebookPersistentState
extends MISavedData {
    private static final SavedData.Factory<GuidebookPersistentState> FACTORY = new SavedData.Factory(GuidebookPersistentState::new, GuidebookPersistentState::fromNbt);
    private static final String NAME = "modern_industrialization_guidebook";
    private final Set<String> receivedPlayers;

    private GuidebookPersistentState(Set<String> receivedPlayers) {
        this.receivedPlayers = receivedPlayers;
    }

    private GuidebookPersistentState() {
        this(new HashSet<String>());
    }

    public boolean hasPlayerReceivedGuidebook(Player player) {
        return this.receivedPlayers.contains(player.getStringUUID());
    }

    public void addPlayerReceivedGuidebook(Player player) {
        this.receivedPlayers.add(player.getStringUUID());
        this.setDirty();
    }

    public static GuidebookPersistentState fromNbt(CompoundTag tag) {
        HashSet<String> receivedPlayers = new HashSet<String>();
        ListTag list = tag.getList("receivedPlayers", 8);
        for (int i = 0; i < list.size(); ++i) {
            receivedPlayers.add(list.getString(i));
        }
        return new GuidebookPersistentState(receivedPlayers);
    }

    public CompoundTag save(CompoundTag tag) {
        ListTag list = new ListTag();
        for (String receivedPlayer : this.receivedPlayers) {
            list.add((Object)StringTag.valueOf((String)receivedPlayer));
        }
        tag.put("receivedPlayers", (Tag)list);
        return tag;
    }

    public static GuidebookPersistentState get(MinecraftServer server) {
        ServerLevel world = server.getLevel(ServerLevel.OVERWORLD);
        return (GuidebookPersistentState)world.getDataStorage().computeIfAbsent(FACTORY, NAME);
    }
}

