/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network;

import aztech.modern_industrialization.network.MIPackets;
import aztech.modern_industrialization.proxy.CommonProxy;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public interface BasePacket
extends CustomPacketPayload {
    public void write(FriendlyByteBuf var1);

    public void handle(Context var1);

    default public void sendToServer() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{this});
    }

    default public void sendToClient(ServerPlayer player) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{this});
    }

    default public ResourceLocation id() {
        return MIPackets.packetLocations.get(this.getClass());
    }

    public record Context(Class<? extends BasePacket> clazz, PlayPayloadContext inner) {
        public boolean isOnClient() {
            return this.inner.flow().isClientbound();
        }

        public void assertOnServer() {
            if (this.isOnClient()) {
                throw new IllegalArgumentException("Cannot handle packet on client: " + this.clazz);
            }
        }

        public void assertOnClient() {
            if (!this.isOnClient()) {
                throw new IllegalArgumentException("Cannot handle packet on server: " + this.clazz);
            }
        }

        public Player getPlayer() {
            return this.isOnClient() ? CommonProxy.INSTANCE.getClientPlayer() : Objects.requireNonNull((Player)this.inner.player().get());
        }
    }
}

