/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.network.BasePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public record AdjustSlotCapacityPacket(int syncId, int slotId, boolean isIncrease, boolean isShiftDown) implements BasePacket
{
    public AdjustSlotCapacityPacket(FriendlyByteBuf buf) {
        this(buf.readUnsignedByte(), buf.readVarInt(), buf.readBoolean(), buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.syncId);
        buf.writeVarInt(this.slotId);
        buf.writeBoolean(this.isIncrease);
        buf.writeBoolean(this.isShiftDown);
    }

    @Override
    public void handle(BasePacket.Context ctx) {
        Slot slot;
        ctx.assertOnServer();
        AbstractContainerMenu sh = ctx.getPlayer().containerMenu;
        if (sh.containerId == this.syncId && (slot = sh.getSlot(this.slotId)) instanceof ConfigurableItemStack.ConfigurableItemSlot) {
            ConfigurableItemStack.ConfigurableItemSlot confSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot;
            confSlot.getConfStack().adjustCapacity(this.isIncrease, this.isShiftDown);
        }
    }
}

