/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.MachineMenuServer;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.network.BasePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ChangeShapePacket(int syncId, int shapeLine, boolean clickedLeftButton) implements BasePacket
{
    public ChangeShapePacket(FriendlyByteBuf buf) {
        this(buf.readUnsignedByte(), buf.readVarInt(), buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.syncId);
        buf.writeVarInt(this.shapeLine);
        buf.writeBoolean(this.clickedLeftButton);
    }

    @Override
    public void handle(BasePacket.Context ctx) {
        ctx.assertOnServer();
        AbstractContainerMenu menu = ctx.getPlayer().containerMenu;
        if (menu.containerId == this.syncId && menu instanceof MachineMenuServer) {
            MachineMenuServer machineMenu = (MachineMenuServer)menu;
            ShapeSelection.Server shapeSelection = (ShapeSelection.Server)machineMenu.blockEntity.getComponent(GuiComponents.SHAPE_SELECTION);
            shapeSelection.behavior.handleClick(this.shapeLine, this.clickedLeftButton ? -1 : 1);
        }
    }
}

