/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.machines.gui.MachineMenuCommon;
import aztech.modern_industrialization.network.BasePacket;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;

public record MachineComponentSyncPacket(int syncId, int componentIndex, byte[] data) implements BasePacket
{
    public MachineComponentSyncPacket(FriendlyByteBuf buf) {
        this(buf.readUnsignedByte(), buf.readVarInt(), buf.readByteArray());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.syncId);
        buf.writeVarInt(this.componentIndex);
        buf.writeByteArray(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(BasePacket.Context ctx) {
        ctx.assertOnClient();
        if (ctx.getPlayer().containerMenu.containerId == this.syncId) {
            MachineMenuCommon screenHandler = (MachineMenuCommon)ctx.getPlayer().containerMenu;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.data));
            try {
                screenHandler.readClientComponentSyncData(this.componentIndex, buf);
            }
            finally {
                buf.release();
            }
        }
    }
}

