/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.MachineMenuServer;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLocking;
import aztech.modern_industrialization.network.BasePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ReiLockSlotsPacket(int containedId, ResourceLocation recipeId) implements BasePacket
{
    public ReiLockSlotsPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readResourceLocation());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.containedId);
        buf.writeResourceLocation(this.recipeId);
    }

    @Override
    public void handle(BasePacket.Context ctx) {
        ctx.assertOnServer();
        AbstractContainerMenu sh = ctx.getPlayer().containerMenu;
        if (sh.containerId == this.containedId && sh instanceof MachineMenuServer) {
            MachineMenuServer screenHandler = (MachineMenuServer)sh;
            ReiSlotLocking.Server slotLocking = (ReiSlotLocking.Server)screenHandler.blockEntity.getComponent(GuiComponents.REI_SLOT_LOCKING);
            if (!slotLocking.allowLocking.get().booleanValue()) {
                return;
            }
            slotLocking.slotLockable.lockSlots(this.recipeId, ctx.getPlayer().getInventory());
        }
    }
}

