/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineMenuServer;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.network.BasePacket;
import net.minecraft.network.FriendlyByteBuf;

public record SetAutoExtractPacket(int syncId, boolean isItem, boolean isExtract) implements BasePacket
{
    public SetAutoExtractPacket(FriendlyByteBuf buf) {
        this(buf.readUnsignedByte(), buf.readBoolean(), buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.syncId);
        buf.writeBoolean(this.isItem);
        buf.writeBoolean(this.isExtract);
    }

    @Override
    public void handle(BasePacket.Context ctx) {
        ctx.assertOnServer();
        if (ctx.getPlayer().containerMenu.containerId == this.syncId) {
            MachineMenuServer screenHandler = (MachineMenuServer)ctx.getPlayer().containerMenu;
            AutoExtract.Server autoExtract = (AutoExtract.Server)screenHandler.blockEntity.getComponent(GuiComponents.AUTO_EXTRACT);
            OrientationComponent orientation = autoExtract.getOrientation();
            if (this.isItem) {
                orientation.extractItems = this.isExtract;
            } else {
                orientation.extractFluids = this.isExtract;
            }
            screenHandler.blockEntity.setChanged();
            screenHandler.blockEntity.sync();
        }
    }
}

