/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableScreenHandler;
import aztech.modern_industrialization.network.BasePacket;
import java.util.Objects;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public record UpdateFluidSlotPacket(int syncId, int stackId, ConfigurableFluidStack newStack) implements BasePacket
{
    public UpdateFluidSlotPacket(FriendlyByteBuf buf) {
        this(buf.readUnsignedByte(), buf.readVarInt(), new ConfigurableFluidStack(buf.readNbt()));
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.syncId);
        buf.writeVarInt(this.stackId);
        buf.writeNbt((Tag)this.newStack.toNbt());
    }

    @Override
    public void handle(BasePacket.Context ctx) {
        ctx.assertOnClient();
        AbstractContainerMenu sh = ctx.getPlayer().containerMenu;
        if (sh.containerId == this.syncId) {
            ConfigurableScreenHandler csh = (ConfigurableScreenHandler)sh;
            ConfigurableFluidStack oldStack = csh.inventory.getFluidStacks().get(this.stackId);
            csh.inventory.getFluidStacks().set(this.stackId, this.newStack);
            for (int i = 0; i < csh.slots.size(); ++i) {
                ConfigurableFluidStack.ConfigurableFluidSlot fs;
                Slot slot = (Slot)csh.slots.get(i);
                if (!(slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) || (fs = (ConfigurableFluidStack.ConfigurableFluidSlot)slot).getConfStack() != oldStack) continue;
                ConfigurableFluidStack configurableFluidStack = this.newStack;
                Objects.requireNonNull(configurableFluidStack);
                csh.updateSlot(i, configurableFluidStack.new ConfigurableFluidStack.ConfigurableFluidSlot(fs));
                return;
            }
            throw new RuntimeException("Could not find slot to replace!");
        }
    }
}

